

<?php $__env->startSection('content'); ?>

<style>
    body {
        background-color: #f5f7fa;
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        color: #2c3e50;
    }
    .container-main {
        max-width: 1100px;
        margin: 30px auto;
        background: white;
        padding: 30px;
        border-radius: 8px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
    }
    h2.page-title {
        font-weight: 700;
        color: #1a237e;
        margin-bottom: 30px;
        text-align: center;
        letter-spacing: 1px;
    }
    .section-title {
        font-weight: 600;
        font-size: 1.2rem;
        color: #3f51b5;
        border-bottom: 2px solid #3f51b5;
        padding-bottom: 8px;
        margin-bottom: 20px;
    }
    .info-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit,minmax(280px,1fr));
        gap: 18px 30px;
        margin-bottom: 35px;
    }
    .info-item strong {
        color: #283593;
    }
    .info-item {
        background-color: #e8eaf6;
        padding: 12px 15px;
        border-radius: 6px;
        font-size: 1rem;
        box-shadow: inset 0 0 3px rgba(0,0,0,0.05);
        transition: transform 0.3s ease;
    }
    .info-item:hover {
        transform: translateY(-3px);
        box-shadow: 0 4px 8px rgba(0,0,0,0.1);
    }
    a.file-link {
        color: #1a237e;
        text-decoration: none;
        font-weight: 600;
        display: inline-flex;
        align-items: center;
        padding: 5px 10px;
        background-color: rgba(63, 81, 181, 0.1);
        border-radius: 4px;
        transition: all 0.3s;
    }
    a.file-link:hover {
        background-color: rgba(63, 81, 181, 0.2);
        transform: translateX(3px);
    }
    a.file-link i {
        margin-right: 5px;
    }
    form .form-label {
        font-weight: 600;
        color: #3949ab;
    }
    form .form-control, form select, form textarea {
        border-radius: 5px;
        border: 1px solid #9fa8da;
        font-size: 1rem;
        padding: 8px 12px;
        transition: border-color 0.3s ease;
    }
    form .form-control:focus, form select:focus, form textarea:focus {
        border-color: #3f51b5;
        box-shadow: 0 0 5px #7986cb;
        outline: none;
    }
    form button.btn-submit {
        background-color: #303f9f;
        border: none;
        color: white;
        font-weight: 700;
        padding: 10px 25px;
        font-size: 1.1rem;
        border-radius: 6px;
        cursor: pointer;
        transition: all 0.3s ease;
        display: block;
        margin: 30px auto 0;
        width: 250px;
    }
    form button.btn-submit:hover {
        background-color: #283593;
        transform: translateY(-2px);
        box-shadow: 0 4px 8px rgba(0,0,0,0.15);
    }
    /* خريطة تفاعلية محسنة */
    .interactive-map {
        width: 100%;
        height: 400px;
        border-radius: 8px;
        overflow: hidden;
        margin-bottom: 35px;
        box-shadow: 0 4px 12px rgba(0,0,0,0.15);
        border: 1px solid #ddd;
        position: relative;
    }
    .map-overlay {
        position: absolute;
        top: 10px;
        right: 10px;
        background: white;
        padding: 10px;
        border-radius: 5px;
        box-shadow: 0 2px 6px rgba(0,0,0,0.3);
        z-index: 1;
        max-width: 300px;
    }
    .map-overlay p {
        margin: 0;
        font-size: 0.9rem;
        color: #333;
    }
    .map-overlay strong {
        color: #1a237e;
    }
    .license-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 30px;
        padding-bottom: 15px;
        border-bottom: 1px solid #e0e0e0;
    }
    .license-number {
        background-color: #1a237e;
        color: white;
        padding: 5px 15px;
        border-radius: 20px;
        font-weight: 600;
    }
    .status-badge {
        display: inline-block;
        padding: 5px 12px;
        border-radius: 20px;
        font-weight: 600;
        font-size: 0.9rem;
    }
    .status-under_review {
        background-color: #ffecb3;
        color: #f57c00;
    }
    .status-approved {
        background-color: #c8e6c9;
        color: #388e3c;
    }
    .status-rejected {
        background-color: #ffcdd2;
        color: #d32f2f;
    }
    .file-grid {
        display: grid;
        grid-template-columns: repeat(auto-fill, minmax(250px, 1fr));
        gap: 20px;
    }
    .file-card {
        border: 1px solid #e0e0e0;
        border-radius: 8px;
        padding: 15px;
        transition: all 0.3s;
        background-color: white;
        text-align: center;
    }
    .file-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 6px 15px rgba(0,0,0,0.1);
        border-color: #3f51b5;
    }
    .file-icon {
        font-size: 2.5rem;
        color: #3f51b5;
        margin-bottom: 10px;
    }
</style>

<div class="container-main">
    <div class="license-header">
        <h2 class="page-title">تفاصيل طلب الترخيص</h2>
        <div class="license-number">رقم الترخيص: #<?php echo e($license->id); ?></div>
    </div>
    
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <strong>حالة الترخيص:</strong>
            <?php if($license->status == 'under_review'): ?>
                <span class="status-badge status-under_review">قيد المراجعة</span>
            <?php elseif($license->status == 'approved'): ?>
                <span class="status-badge status-approved">مقبول</span>
            <?php else: ?>
                <span class="status-badge status-rejected">مرفوض</span>
            <?php endif; ?>
        </div>
        <div>
            <strong>تاريخ الطلب:</strong>
            <span><?php echo e($license->created_at->format('Y-m-d')); ?></span>
        </div>
    </div>

    <h3 class="section-title">بيانات المدرسة</h3>
    <div class="info-grid">
        <div class="info-item">
            <strong>اسم المدرسة:</strong>
            <?php echo e($license->branch->school->school_name ?? '-'); ?>

        </div>
        <div class="info-item">
            <div>
                <strong>نوع المدرسة:</strong>
                <?php
                    $types = json_decode($license->branch->school->type ?? '[]', true);
                ?>
                <?php echo e(!empty($types) ? implode('، ', $types) : '-'); ?>

            </div>
        </div>
        <div class="info-item">
            <strong>المحافظة:</strong>
            <?php echo e($license->branch->school->city->name ?? '-'); ?>

        </div>
    </div>

    
    <div>
        <h3 class="section-title">بيانات الفرع</h3>
        <div class="info-grid">
            <div class="info-item"><strong>اسم الفرع:</strong> <?php echo e($license->branch->name ?? '—'); ?></div>
            <div class="info-item"><strong>المنطقة التعليمية:</strong> <?php echo e($license->branch->area->name ?? '—'); ?></div>
            <div class="info-item"><strong>عنوان المدرسة:</strong> <?php echo e($license->branch->school_address ?? '—'); ?></div>
            <div class="info-item"><strong>أقرب معلم بارز:</strong> <?php echo e($license->branch->nearest_landmark ?? '—'); ?></div>
            <div class="info-item"><strong>اسم مدير المدرسة:</strong> <?php echo e($license->branch->name_manage ?? '—'); ?></div>
            <div class="info-item"><strong>هاتف مدير المدرسة:</strong> <?php echo e($license->branch->phone_manage ?? '—'); ?></div>
            <div class="info-item"><strong>رقم الهاتف الثابت:</strong> <?php echo e($license->branch->phone ?? '—'); ?></div>
            <div class="info-item" style="grid-column: span 2;">
                <strong>وصف المدرسة:</strong><br> <?php echo nl2br(e($license->branch->description ?? '—')); ?>

            </div>
        </div>
    </div>

    
    <div>
        <h3 class="section-title">الملفات المرفقة</h3>
        <div class="file-grid">
            <?php
                $files = [
                    'السيرة الذاتية لمدير المدرسة' => $license->branch->cv_manage,
                    'عقد الإيجار' => $license->branch->contrect_image,
                    'مخطط مبنى المدرسة' => $license->branch->plan_image,
                    'الصورة الرئيسية' => $license->branch->main_image,
                    'الصور الفرعية' => $license->branch->secondary_image,
                    'دراسة الجدوى' => $license->branch->file_feasibility,
                    'كشف الحساب البنكي' => $license->branch->bank_statement,
                    'وثائق أخرى' => $license->branch->other_document,
                ];
                
                $icons = [
                    'السيرة الذاتية لمدير المدرسة' => 'bi-file-earmark-pdf',
                    'عقد الإيجار' => 'bi-file-earmark-image',
                    'مخطط مبنى المدرسة' => 'bi-file-earmark-image',
                    'الصورة الرئيسية' => 'bi-file-earmark-image',
                    'الصور الفرعية' => 'bi-file-earmark-image',
                    'دراسة الجدوى' => 'bi-file-earmark-pdf',
                    'كشف الحساب البنكي' => 'bi-file-earmark-pdf',
                    'وثائق أخرى' => 'bi-file-earmark-text',
                ];
            ?>
            
            <?php $__currentLoopData = $files; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $label => $file): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="file-card">
                    <div class="file-icon">
                        <i class="bi <?php echo e($icons[$label]); ?>"></i>
                    </div>
                    <div class="mb-2"><strong><?php echo e($label); ?></strong></div>
                    <?php if($file): ?>
                        <a href="<?php echo e(asset('storage/' . $file)); ?>" target="_blank" class="file-link">
                            <i class="bi bi-download"></i> تحميل الملف
                        </a>
                    <?php else: ?>
                        <span class="text-muted">—</span>
                    <?php endif; ?>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>


    
    <?php if($license->branch->latitude && $license->branch->longitude): ?>
    <div>
        <h3 class="section-title">الموقع على الخريطة</h3>

        <div class="interactive-map" style="position: relative; width: 100%; height: 400px;">
            <div id="map" style="width: 100%; height: 100%;"></div>

            <div class="map-overlay" style="position: absolute; top: 10px; left: 10px; background: white; padding: 10px; border-radius: 8px; box-shadow: 0 2px 6px rgba(0,0,0,0.3);">
                <p><strong>الإحداثيات:</strong> <?php echo e($license->branch->latitude); ?>, <?php echo e($license->branch->longitude); ?></p>
                <p><strong>العنوان:</strong> <?php echo e($license->branch->school_address); ?></p>
            </div>
        </div>
    </div>

    
    <script>
        function initMap() {
            var location = {
                lat: parseFloat("<?php echo e($license->branch->latitude); ?>"),
                lng: parseFloat("<?php echo e($license->branch->longitude); ?>")
            };

            var map = new google.maps.Map(document.getElementById("map"), {
                zoom: 16,
                center: location
            });

            var marker = new google.maps.Marker({
                position: location,
                map: map
            });
        }
    </script>

    
    <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyBpgVKnqL33ZzJDM4r3ejHsJGdzp3jnXmU&callback=initMap" async defer></script>
<?php endif; ?>


    
    <div>
        <h3 class="section-title">تعديل حالة الترخيص</h3>
    
        <form action="<?php echo e(route('admin.licenses.updateStatus', $license->id)); ?>" method="POST" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <div class="row">
                <div class="col-md-6 mb-3">
                    <label for="status" class="form-label">حالة الترخيص</label>
                    <select name="status" id="status" class="form-select">
                        <option value="under_review" <?php echo e($license->status == 'under_review' ? 'selected' : ''); ?>>قيد المراجعة</option>
                        <option value="approved" <?php echo e($license->status == 'approved' ? 'selected' : ''); ?>>مقبول</option>
                        <option value="rejected" <?php echo e($license->status == 'rejected' ? 'selected' : ''); ?>>مرفوض</option>
                    </select>
                </div>
                
                <div class="col-md-6 mb-3">
                    <label class="form-label">المستخدم الحالي</label>
                    <input type="text" class="form-control" value="<?php echo e(auth()->user()->name); ?>" disabled>
                    <input type="hidden" name="current_user_id" value="<?php echo e(auth()->user()->id); ?>">
                </div>
                
                <div class="col-md-6 mb-3">
                    <label for="next_user_id" class="form-label">المستخدم التالي</label>
                    <select name="next_user_id" id="next_user_id" class="form-select">
                        <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($user->id); ?>" <?php echo e($license->next_user_id == $user->id ? 'selected' : ''); ?>>
                                <?php echo e($user->name); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                
                <div class="col-md-6 mb-3">
                    <label for="final_status" class="form-label">الحالة النهائية</label>
                    <input type="text" name="final_status" id="final_status" class="form-control" value="<?php echo e($license->final_status); ?>">
                </div>
                
                <div class="col-12 mb-3">
                    <label for="note" class="form-label">ملاحظات</label>
                    <textarea name="note" id="note" rows="4" class="form-control"><?php echo e($license->note); ?></textarea>
                </div>
                
                <div class="col-md-6 mb-4">
                    <label for="approval_file" class="form-label">رفع ملف الموافقة من الوزارة (PDF)</label>
                    <input type="file" name="approval_file" id="approval_file" class="form-control" accept="application/pdf">
                </div>
                
                <div class="col-md-6 mb-4">
                    <?php if($license->approval_file): ?>
                        <label class="form-label">ملف الموافقة الحالي:</label>
                        <div class="mt-1">
                            <a href="<?php echo e(asset('storage/' . $license->approval_file)); ?>" class="file-link" target="_blank">
                                <i class="bi bi-download"></i> عرض الملف
                            </a>




                            
                        </div>
                    <?php endif; ?>
                </div>
            </div>
    
            <button type="submit" class="btn-submit">حفظ التعديلات</button>
        </form>
    </div>
</div>

<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\king6\schoolsystem\resources\views/admin/licenses/add.blade.php ENDPATH**/ ?>