

<?php $__env->startSection('content'); ?>


<div class="container" style="direction: rtl; font-family: 'Tahoma', sans-serif;">
    <h2 class="mb-4 text-center text-primary">📝 تعديل بيانات المستخدم</h2>

    <?php if($errors->any()): ?>
        <div class="alert alert-danger">
            <ul class="mb-0">
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li>⚠️ <?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
    <?php endif; ?>

    <form action="<?php echo e(route('users.update', $user->id)); ?>" method="POST" enctype="multipart/form-data" class="bg-light p-4 rounded shadow-sm">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?>

        <div class="row">
            <!-- الاسم -->
            <div class="col-md-6 mb-3">
                <label>الاسم:</label>
                <input type="text" name="name" class="form-control" value="<?php echo e($user->name); ?>" required>
            </div>

            <!-- البريد -->
            <div class="col-md-6 mb-3">
                <label>البريد الإلكتروني:</label>
                <input type="email" name="email" class="form-control" value="<?php echo e($user->email); ?>">
            </div>

            <!-- الهاتف -->
            <div class="col-md-6 mb-3">
                <label>رقم الهاتف:</label>
                <input type="text" name="phone" class="form-control" value="<?php echo e($user->phone); ?>">
            </div>

            <!-- كلمة المرور -->
            <div class="col-md-6 mb-3">
                <label>كلمة المرور (اتركها فارغة إن لم ترغب بتغييرها):</label>
                <input type="password" name="password" class="form-control">
            </div>

            <!-- الجنس -->
            <div class="col-md-6 mb-3">
                <label>الجنس:</label><br>
                <div class="form-check form-check-inline">
                    <input class="form-check-input" type="radio" name="gender" value="male" <?php echo e($user->gender == 'male' ? 'checked' : ''); ?>>
                    <label class="form-check-label">ذكر</label>
                </div>
                <div class="form-check form-check-inline">
                    <input class="form-check-input" type="radio" name="gender" value="femal" <?php echo e($user->gender == 'female' ? 'checked' : ''); ?>>
                    <label class="form-check-label">أنثى</label>
                </div>
            </div>

            <!-- المحافظة -->
            <div class="col-md-6 mb-3">
                <label>المحافظة:</label>
                <select name="city_id" class="form-control" required>
                    <option value=""> اختر المحافظة </option>
                    <?php $__currentLoopData = $cities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $city): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($city->id); ?>" <?php echo e($user->city_id == $city->id ? 'selected' : ''); ?>>
                            <?php echo e($city->name); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>

            <!-- صورة المستخدم -->
            <div class="col-md-6 mb-3">
                <label>الصورة الشخصية:</label>
                <input type="file" name="image" class="form-control">
                <?php if($user->image): ?>
                    <div class="mt-2">
                        <img src="<?php echo e(asset($user->image)); ?>" alt="الصورة الحالية" width="100" class="img-thumbnail">
                    </div>
                <?php endif; ?>
            </div>
        </div>

        <!-- زر الحفظ -->
        <div class="text-center mt-4">
            <button type="submit" class="btn btn-primary px-5">
                💾 حفظ التعديلات
            </button>
        </div>
    </form>
</div>


<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layout.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\king6\schoolsystem\resources\views/admin/user/edit_user.blade.php ENDPATH**/ ?>