

<?php $__env->startSection('content'); ?>
<div class="container mt-4">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h4 class="mb-0"><i class="bi bi-shield-lock"></i> أدوار المستخدمين</h4>
        
        <!-- نموذج البحث بالبريد الإلكتروني -->
        <form action="<?php echo e(route('users.roles')); ?>" method="GET" class="d-flex" style="max-width: 400px;">
            <div class="input-group">
                <input 
                    type="text" 
                    name="email" 
                    class="form-control" 
                    placeholder="البحث بالبريد الإلكتروني..."
                    value="<?php echo e(request('email')); ?>"
                >
                <button class="btn btn-primary" type="submit">
                    <i class="bi bi-search"></i> بحث
                </button>
                <?php if(request()->has('email')): ?>
                    <a href="<?php echo e(route('users.roles')); ?>" class="btn btn-secondary">
                        <i class="bi bi-arrow-counterclockwise"></i> إعادة تعيين
                    </a>
                <?php endif; ?>
            </div>
        </form>
    </div>

    <?php if(session('success')): ?>
        <div class="alert alert-success"><?php echo e(session('success')); ?></div>
    <?php endif; ?>

    <?php if(request()->has('email') && $users->isEmpty()): ?>
        <div class="alert alert-warning">
            لم يتم العثور على أي مستخدمين للبريد الإلكتروني: "<?php echo e(request('email')); ?>"
        </div>
    <?php endif; ?>

    <table class="table table-bordered table-striped text-center">
        <thead class="table-primary">
            <tr>
                <th>الرقم</th>
                <th>الاسم</th>
                <th>البريد</th>
                <th>الدور / الأدوار</th>
                <th>الإجراء</th>
            </tr>
        </thead>
        <tbody>
            <?php $__empty_1 = true; $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <tr>
                <td><?php echo e($user->id); ?></td>
                <td><?php echo e($user->name); ?></td>
                <td><?php echo e($user->email); ?></td>
                <td>
                    <?php if($user->roles->count()): ?>
                        <?php $__currentLoopData = $user->roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <span class="badge bg-info"><?php echo e($role->name); ?></span>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php else: ?>
                        <span class="text-muted">لا يوجد دور</span>
                    <?php endif; ?>
                </td>
                <td>
                    <a href="<?php echo e(route('users.assignRoleForm', $user->id)); ?>" class="btn btn-sm btn-primary">
                        <i class="bi bi-pencil-square"></i> تعيين دور
                    </a>
                </td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <tr>
                <td colspan="5" class="text-muted">
                    <?php if(request()->has('email')): ?>
                        لا توجد نتائج للبحث
                    <?php else: ?>
                        لا توجد مستخدمين
                    <?php endif; ?>
                </td>
            </tr>
            <?php endif; ?>
        </tbody>
    </table>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('admin.layout.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\king6\schoolsystem\resources\views/admin/role/index.blade.php ENDPATH**/ ?>