
<?php $__env->startSection('content'); ?>
<div class="container mt-4">
    <div class="card shadow border-0">
        <div class="card-header bg-primary text-white py-3">
            <h4 class="mb-0 fw-bold">
                <i class="fas fa-map-marker-alt me-2"></i>
                طلبات التراخيص في محافظة
            </h4>
        </div>
        
        <div class="card-body">
           <?php if($licenses->isEmpty()): ?>
    <div class="alert alert-info text-center p-4 fs-5 rounded-3">
        <i class="fas fa-info-circle me-2"></i>
        لا توجد طلبات تراخيص في  هذه المحافظة <?php echo e($city->name ?? 'غير معروفة'); ?>

    </div>
<?php else: ?>

                <div class="table-responsive">
                    <table class="table table-bordered table-striped table-hover">
                        <thead class="table-light">
                            <tr>
                                <th class="py-3">الرقم</th>
                                <th class="py-3">اسم المدرسة</th>
                                <th class="py-3">اسم الفرع</th>
                                <th class="py-3">الحالة</th>
                                <th class="py-3">الملاحظات</th>
                                <th class="py-3">تاريخ الطلب</th>
                                <th class="py-3">الإجراءات</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $licenses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $license): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td class="py-3"><?php echo e($loop->iteration); ?></td>
                                <td class="py-3"><?php echo e($license->branch->school->school_name ?? 'غير معروف'); ?></td>
                                <td class="py-3"><?php echo e($license->branch->name ?? 'غير معروف'); ?></td>
                                <td class="py-3">
                                    <?php switch($license->status):
                                        case ('under_review'): ?>
                                            <span class="badge bg-warning text-dark">قيد المراجعة</span>
                                        <?php break; ?>
                                        <?php case ('approved'): ?>
                                            <span class="badge bg-success">مقبول</span>
                                        <?php break; ?>
                                        <?php case ('rejected'): ?>
                                            <span class="badge bg-danger">مرفوض</span>
                                        <?php break; ?>
                                        <?php default: ?>
                                            <span class="badge bg-secondary"><?php echo e($license->status); ?></span>
                                    <?php endswitch; ?>
                                </td>
                                <td class="py-3"><?php echo e($license->note ?? '-'); ?></td>
                                <td class="py-3"><?php echo e($license->created_at->format('Y-m-d')); ?></td>
                                <td class="py-3">
                                    <a href="<?php echo e(route('committee.licenses.add', $license->id)); ?>" 
                                       class="btn btn-info btn-sm">
                                       <i class="fas fa-eye me-1"></i> عرض
                                    </a>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('committee.layout.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\king6\schoolsystem\resources\views/committee/city/by_city.blade.php ENDPATH**/ ?>