

<?php $__env->startSection('title', 'طلب ترخيص - بيانات المدرسة'); ?>

<?php $__env->startSection('content'); ?>

<div class="container mt-4" dir="rtl">
    <div class="card shadow rounded-3 border-0">
        <div class="card-header bg-primary text-white text-center">
            <h4 class="mb-0">طلب ترخيص - بيانات المدرسة</h4>
        </div>

        <div class="card-body">

            <?php if(session('success')): ?>
                <div class="alert alert-success text-center"><?php echo e(session('success')); ?></div>
            <?php endif; ?>
            <?php if(Auth::check()): ?>
    <div class="alert alert-success">مرحبًا، <?php echo e(Auth::user()->name); ?>، أنت مسجّل دخول.</div>
<?php else: ?>
    <div class="alert alert-danger">❌ لم تقم بتسجيل الدخول!</div>
<?php endif; ?>


            <form action="<?php echo e(route('client.license.step1')); ?>" method="POST" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>

                
                <div class="mb-3">
                    <label for="school_name" class="form-label fw-bold">اسم المدرسة <span class="text-danger"></span></label>
                    <input type="text" id="school_name" name="school_name" class="form-control" required>
                </div>

                
                <div class="mb-3">
                    <label for="city_id" class="form-label fw-bold">المحافظة <span class="text-danger"></span></label>
                    <select name="city_id" id="city_id" class="form-select" required>
                        <option value="">اختر المحافظة</option>
                        <?php $__currentLoopData = $cities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $city): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($city->id); ?>"><?php echo e($city->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>

                
         

                <div class="form-check">
                        <input class="form-check-input" type="checkbox" name="type[]" value="تمهيدي" id="type2">
                        <label class="form-check-label" for="type1">تمهيدي</label>
                    </div>
                 
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" name="type[]" value="أساسي" id="type3">
                        <label class="form-check-label" for="type1">أساسي</label>
                    </div>
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" name="type[]" value="إعدادي" id="type4">
                        <label class="form-check-label" for="type2">إعدادي</label>
                    </div>
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" name="type[]" value="ثانوي" id="type5">
                        <label class="form-check-label" for="type3">ثانوي</label>
                    </div>
                </div>

                
                <div class="mb-4">
                    <label for="logo" class="form-label fw-bold">شعار المدرسة (صورة)</label>
                    <input type="file" id="logo" name="logo" class="form-control">
                </div>

                
                <div class="text-center">
                    <button type="submit" class="btn btn-success px-4 py-2">
                        <i class="bi bi-save"> حفظ البيانات
                     </i> 

                    </button>
                </div>

            </form>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.rtl.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">

<?php echo $__env->make('client.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\king6\schoolsystem\resources\views/client/license_step1.blade.php ENDPATH**/ ?>