<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="utf-8">
    <title>لوحة التحكم | AdminLTE v4</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- Fonts -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fontsource/source-sans-3@5.0.12/index.css" crossorigin="anonymous">
    <!-- Overlay Scrollbars -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/overlayscrollbars@2.3.0/styles/overlayscrollbars.min.css" crossorigin="anonymous">
    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.min.css" crossorigin="anonymous">
    <!-- AdminLTE CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('admin/css/adminlte.rtl.css')); ?>">
    <!-- ApexCharts -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/apexcharts@3.37.1/apexcharts.css" crossorigin="anonymous">
    <!-- Vector Map -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/jsvectormap@1.5.3/dist/css/jsvectormap.min.css" crossorigin="anonymous">

    <style>
        :root {
            --sidebar-color: #2c3e50;
            --sidebar-hover: #1a252f;
            --sidebar-active: #3498db;
            --sidebar-text: #ecf0f1;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            color: #34495e;
        }

        h1, h2, h3, h4, h5, h6 {
            color: #2c3e50;
            font-weight: 600;
        }

        .main-sidebar {
            background: linear-gradient(180deg, var(--sidebar-color) 0%, var(--sidebar-hover) 100%) !important;
            box-shadow: 3px 0 10px rgba(0,0,0,0.2);
        }

        .sidebar-dark-primary .nav-sidebar > .nav-item > .nav-link.active {
            background-color: var(--sidebar-active) !important;
            color: white;
            border-left: 4px solid white;
        }

        .nav-sidebar .nav-link p,
        .nav-sidebar .nav-link i {
            color: var(--sidebar-text);
            transition: 0.3s ease;
        }

        .nav-sidebar .nav-link:hover p,
        .nav-sidebar .nav-link:hover i {
            color: white;
        }

        .content-wrapper {
            background: #f8f9fa;
        }

        .main-header {
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
            border-bottom: 1px solid #eaeaea;
        }

        .card {
            border-radius: 10px;
            box-shadow: 0 4px 6px rgba(0,0,0,0.05);
            border: none;
        }

        .main-footer {
            background: #fff;
            border-top: 1px solid #eaeaea;
            color: #7b8a8b;
            padding: 15px;
            font-size: 0.9rem;
            text-align: center;
        }
    </style>
</head>

<body class="layout-fixed sidebar-expand-lg bg-body-tertiary">
    <div class="app-wrapper">
        <!-- Header -->
        <nav class="app-header navbar navbar-expand bg-body">
            <div class="container-fluid">
                <ul class="navbar-nav">
                    <li class="nav-item">
                        <a class="nav-link" data-lte-toggle="sidebar" href="#">
                            <i class="bi bi-list"></i>
                        </a>
                    </li>
                    <li class="nav-item d-none d-md-block">
                        <a href="<?php echo e(route('admin.main_menus')); ?>" class="nav-link">الرئيسية</a>
                    </li>
                
                </ul>

                <ul class="navbar-nav ms-auto">
                    <!-- بحث -->
                  
                    </li>
                    <!-- اشعارات -->
                    
                        <div class="dropdown-menu dropdown-menu-lg dropdown-menu-end">
                            <span class="dropdown-item dropdown-header"></span>
                            <div class="dropdown-divider"></div>
                            <a href="#" class="dropdown-item">
                                <i class="bi bi-envelope me-2"></i>
                            </a>
                            <div class="dropdown-divider"></div>
                            <a href="#" class="dropdown-item dropdown-footer">عرض كل الإشعارات</a>
                        </div>
                    </li>
                    <!-- ملف المستخدم -->
                    <li class="nav-item dropdown user-menu">
                        <a href="#" class="nav-link dropdown-toggle" data-bs-toggle="dropdown">
                            <img src="<?php echo e(asset('img.jpg')); ?>" class="user-image rounded-circle" alt="logo">
                            <span class="d-none d-md-inline">Admin</span>
                        </a>
                        <ul class="dropdown-menu dropdown-menu-lg dropdown-menu-end">
                            <li class="user-header text-bg-primary">
                                <img src="<?php echo e(asset('admin/dist/assets/img/user2-160x160.jpg')); ?>" class="rounded-circle" alt="User Image">
                                <p>المدير العام - مشرف النظام<br><small>عضو منذ 2024</small></p>
                            </li>
                            <li class="user-footer">
                                <a href="#" class="btn btn-default btn-flat">الملف الشخصي</a>
                                <a href="#" class="btn btn-default btn-flat float-end">تسجيل الخروج</a>
                            </li>
                        </ul>
                    </li>
                </ul>
            </div>
        </nav>

        <!-- Sidebar -->
        <aside class="app-sidebar bg-body-secondary shadow" data-bs-theme="dark">
            <div class="sidebar-brand">
                <a href="#" class="brand-link">
                    <img src="<?php echo e(asset('admin/assets/img/AdminLTELogo.png')); ?>" class="brand-image" alt="Logo">
                    <span class="brand-text fw-light">لوحة التحكم</span>
                </a>
            </div>
            <div class="sidebar-wrapper">
                <?php echo $__env->make('admin.includes.nav', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?> 
            </div>
        </aside>

        <!-- Main Content -->
        <main class="app-main">
            <div class="app-content-header">
                <div class="container-fluid">
                    <?php echo $__env->yieldContent('content'); ?>
                </div>
            </div>
        </main>

        <!-- Footer -->
        <footer class="app-footer">
            <div class="float-end d-none d-sm-inline">إصدار الإدارة</div>
            <strong>حقوق النشر &copy; 2024 <a href="https://adminlte.io">AdminLTE</a>.</strong> جميع الحقوق محفوظة.
        </footer>
    </div>

    <!-- Scripts -->
    <script src="https://cdn.jsdelivr.net/npm/overlayscrollbars@2.3.0/browser/overlayscrollbars.browser.es6.min.js" crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.8/umd/popper.min.js" crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js" crossorigin="anonymous"></script>
    <script src="<?php echo e(asset('admin/dist/js/adminlte.js')); ?>"></script>

    <script>
        document.addEventListener("DOMContentLoaded", function () {
            const sidebarWrapper = document.querySelector(".sidebar-wrapper");
            if (sidebarWrapper && typeof OverlayScrollbarsGlobal?.OverlayScrollbars !== "undefined") {
                OverlayScrollbarsGlobal.OverlayScrollbars(sidebarWrapper, {
                    scrollbars: {
                        theme: "os-theme-light",
                        autoHide: "leave",
                        clickScroll: true,
                    }
                });
            }
        });
    </script>
    <?php echo $__env->yieldPushContent('scripts'); ?>
</body>
</html>
<?php /**PATH C:\Users\pc\Desktop\school\resources\views/admin/layout/master.blade.php ENDPATH**/ ?>