

<?php $__env->startSection('content'); ?>




<!DOCTYPE html>
<html lang="ar">
<head>
    <meta charset="UTF-8">
    <title>إضافة مستخدم</title>

    <!-- Bootstrap RTL -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.rtl.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css" rel="stylesheet">
</head>

<body style="direction: rtl; font-family: 'Tahoma', sans-serif; background-color: #f8f9fa;">

<div class="container mt-4 mb-5">
    <div class="card shadow-sm border-0">
        <div class="card-header bg-primary text-white">
            <h4 class="mb-0"><i class="bi bi-person-plus-fill"></i> إضافة مستخدم جديد</h4>
        </div>

        <div class="card-body bg-white">
            
            <?php if($errors->any()): ?>
                <div class="alert alert-danger">
                    <ul class="mb-0">
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo e($error); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            <?php endif; ?>

            
            <form action="<?php echo e(route('users.store')); ?>" method="POST" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>

                <div class="row g-3">
                    <!-- الاسم -->
                    <div class="col-md-6">
                        <label class="form-label">الاسم:</label>
                        <input type="text" name="name" value="<?php echo e(old('name')); ?>" class="form-control" required>
                    </div>

                    <!-- البريد -->
                    <div class="col-md-6">
                        <label class="form-label">البريد الإلكتروني:</label>
                        <input type="email" name="email" value="<?php echo e(old('email')); ?>" class="form-control" required>
                    </div>

                    <!-- الهاتف -->
                    <div class="col-md-6">
                        <label class="form-label">رقم الهاتف:</label>
                        <input type="text" name="phone" value="<?php echo e(old('phone')); ?>" class="form-control">
                    </div>

                    <!-- كلمة المرور -->
                    <div class="col-md-6">
                        <label class="form-label">كلمة المرور:</label>
                        <input type="password" name="password" class="form-control" required>
                    </div>

                    <!-- الجنس -->
                    <div class="col-md-6">
                        <label class="form-label d-block">الجنس:</label>
                        <div class="form-check form-check-inline">
                            <input class="form-check-input" type="radio" name="gender" value="male" <?php echo e(old('gender') == 'male' ? 'checked' : ''); ?>>
                            <label class="form-check-label">ذكر</label>
                        </div>
                        <div class="form-check form-check-inline">
                            <input class="form-check-input" type="radio" name="gender" value="femal" <?php echo e(old('gender') == 'femal' ? 'checked' : ''); ?>>
                            <label class="form-check-label">أنثى</label>
                        </div>
                    </div>

                    <!-- المحافظة -->
                    <div class="col-md-6">
                        <label class="form-label">اختر المحافظة:</label>
                        <select name="city_id" class="form-select" required>
                            <option value="">-- اختر المحافظة --</option>
                            <?php $__currentLoopData = $cities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $city): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($city->id); ?>" <?php echo e(old('city_id') == $city->id ? 'selected' : ''); ?>>
                                    <?php echo e($city->name); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <!-- الصورة -->
                    <div class="col-md-6">
                        <label class="form-label">الصورة الشخصية:</label>
                        <input type="file" name="image" class="form-control">
                    </div>
                </div>

                <div class="text-center mt-4">
                    <button type="submit" class="btn btn-primary px-5">
                        <i class="bi bi-save2-fill"></i> حفظ المستخدم
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

</body>
</html>



<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layout.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\king6\schoolsystem\resources\views/admin/user/add_user.blade.php ENDPATH**/ ?>