

<?php $__env->startSection('content'); ?>

<div class="card p-4">

    <div class="d-flex justify-content-between align-items-center mb-3">
        <h2 class="mb-0">قائمة المدارس</h2>
        <a href="<?php echo e(route('schools.create')); ?>" class="btn btn-success">إضافة مدرسة جديدة</a>
    </div>

    <?php if(session('success')): ?>
        <div class="alert alert-success"><?php echo e(session('success')); ?></div>
    <?php endif; ?>

    <table class="table table-bordered table-striped text-center">
        <thead class="table-light">
            <tr>
                <th>#</th>
                <th>اسم المدرسة</th>
                <th>الأنواع</th>
                <th>المحافظة</th>
                <th>الشعار</th>
                <th>المستخدم</th>
                <th>الإجراءات</th>
            </tr>
        </thead>
        <tbody>
            <?php $__empty_1 = true; $__currentLoopData = $schools; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $school): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr>
                    <td><?php echo e($index + 1); ?></td>
                    <td><?php echo e($school->school_name); ?></td>
                    <td>
                        <?php
                            $types = json_decode($school->type, true) ?? [];
                        ?>

                        <?php $__currentLoopData = $types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <span class="badge bg-info text-dark">
                               <?php if($type === 'pteparatory'): ?> تمهيدي
                                <?php elseif($type === 'primary'): ?> أساسي
                                <?php elseif($type === 'middle'): ?> إعدادي
                                <?php elseif($type === 'high'): ?> ثانوي
                                <?php else: ?> <?php echo e($type); ?>

                                <?php endif; ?>
                            </span>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </td>
                    <td><?php echo e($school->city->name ?? 'غير محددة'); ?></td>
                    <td>
                        <?php if($school->logo): ?>
                            <img src="<?php echo e(asset('storage/' . $school->logo)); ?>" alt="الشعار" width="60" height="60">
                        <?php else: ?>
                            <span class="text-muted">لا يوجد</span>
                        <?php endif; ?>
                    </td>
                    <td><?php echo e($school->user->name ?? 'غير محدد'); ?></td>
                    <td>
                        <a href="<?php echo e(route('schools.edit', $school->id)); ?>" class="btn btn-sm btn-warning">تعديل</a>

                        <form action="<?php echo e(route('schools.destroy', $school->id)); ?>" method="POST" style="display:inline-block;">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <button class="btn btn-sm btn-danger" onclick="return confirm('هل أنت متأكد من الحذف؟')">حذف</button>
                        </form>
                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="7" class="text-muted">لا توجد مدارس حتى الآن</td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>
</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\king6\schoolsystem\resources\views/admin/school/all_school.blade.php ENDPATH**/ ?>