

<?php $__env->startSection('content'); ?>
<div class="card p-4">
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h4>قائمة التراخيص</h4>
        <a href="<?php echo e(route('licenses.create')); ?>" class="btn btn-success">إضافة ترخيص جديد</a>
    </div>

    <table class="table table-bordered table-striped">
        <thead class="table-light">
            <tr>
                <th>الرقم</th>
                <th>اسم الفرع</th>
                <th>الحالة</th>
                <th>المستخدم الحالي</th>
                <th>المستخدم التالي</th>
                <th>الملاحظة</th>
                <th>الحالة النهائية</th>
                <th>إجراءات</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $licenses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $license): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($license->id); ?></td>
                    <td><?php echo e($license->branch->name ?? 'غير متوفر'); ?></td>
                    <td>
                        <?php switch($license->status):
                            case ('under_review'): ?>
                                <span class="badge bg-warning text-dark">قيد المراجعة</span>
                                <?php break; ?>
                            <?php case ('approved'): ?>
                                <span class="badge bg-success">مقبول</span>
                                <?php break; ?>
                            <?php case ('rejected'): ?>
                                <span class="badge bg-danger">مرفوض</span>
                                <?php break; ?>
                        <?php endswitch; ?>
                    </td>
                    <td><?php echo e($license->currentUser->name ?? 'غير متوفر'); ?></td>
                    <td><?php echo e($license->nextUser->name ?? 'غير متوفر'); ?></td>
                    <td><?php echo e($license->note); ?></td>
                    <td><?php echo e($license->final_status); ?></td>
                    <td>
                        <a href="<?php echo e(route('licenses.edit', $license->id)); ?>" class="btn btn-sm btn-warning">تعديل</a>
                        <form action="<?php echo e(route('licenses.destroy', $license->id)); ?>" method="POST" style="display:inline-block;">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('هل تريد حذف هذا الترخيص؟')">حذف</button>
                        </form>
                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\king6\schoolsystem\resources\views/admin/licenses/all_license.blade.php ENDPATH**/ ?>