

<?php $__env->startSection('content'); ?>

<div class="flex justify-between items-center mb-6">
    <h2 class="text-2xl font-bold text-gray-800">قائمة التراخيص</h2>
    <a href="<?php echo e(route('committee.licenses.index')); ?>"
       class="bg-gray-100 hover:bg-gray-200 text-gray-700 text-sm px-4 py-2 rounded-md shadow">
      <br>  ← الرجوع لكل التراخيص
        <br>
    </a>
    <br>
</div>

<div class="overflow-x-auto bg-white rounded-xl shadow p-4">
    <table class="min-w-full text-sm text-right text-gray-700">
        <thead class="bg-gray-50 border-b text-gray-600">
            <tr>
                <th class="py-3 px-4">الرقم</th>
                <th class="py-3 px-4">اسم المدرسة</th>
                <th class="py-3 px-4">الفرع</th>
                <th class="py-3 px-4">الحالة</th>
                <th class="py-3 px-4">تاريخ التقديم</th>
                <th class="py-3 px-4"> عرض التفاصيل</th>
            </tr>
        </thead>
        <tbody>
            <?php $__empty_1 = true; $__currentLoopData = $licenses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $license): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr class="border-b hover:bg-gray-50">
                    <td class="py-3 px-4"><?php echo e($license->id); ?></td>
                    <td class="py-3 px-4"><?php echo e($license->branch->school->school_name ?? '—'); ?></td>
                    <td class="py-3 px-4"><?php echo e($license->branch->name ?? '—'); ?></td>
                    <td class="py-3 px-4">
                        <?php switch($license->status):
                            case ('under_review'): ?>
                                <span class="inline-block px-2 py-1 text-xs bg-yellow-100 text-yellow-800 rounded-full">قيد المراجعة</span>
                                <?php break; ?>
                            <?php case ('approved'): ?>
                                <span class="inline-block px-2 py-1 text-xs bg-green-100 text-green-800 rounded-full">موافق عليه</span>
                                <?php break; ?>
                            <?php case ('rejected'): ?>
                                <span class="inline-block px-2 py-1 text-xs bg-red-100 text-red-800 rounded-full">مرفوض</span>
                                <?php break; ?>
                            <?php default: ?>
                                <span class="inline-block px-2 py-1 text-xs bg-gray-100 text-gray-500 rounded-full">غير معروف</span>
                        <?php endswitch; ?>
                    </td>
                    <td class="py-3 px-4"><?php echo e($license->created_at->format('Y-m-d')); ?></td>
                    <td class="py-3 px-4 text-center">
                      <a href="<?php echo e(route('committee.licenses.add', $license->id)); ?>" class="btn btn-sm btn-info">التفاصيل</a>
                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="6" class="text-center py-6 text-gray-500">لا توجد تراخيص حالياً</td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>
</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('committee.layout.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\king6\schoolsystem\resources\views/committee/licenses/table.blade.php ENDPATH**/ ?>