@extends('committee.layout.master')

@section('content')
<div class="card p-4 shadow rounded-xl">
    <h4 class="text-xl font-semibold mb-6">تفاصيل الترخيص</h4>

    <!-- معلومات المدرسة -->
    <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-6">
        <div><strong>اسم المدرسة:</strong> {{ $license->school->school_name ?? '-' }}</div>
        <div><strong>الفرع:</strong> {{ $license->branch->name ?? '-' }}</div>
        <div><strong>المحافظة:</strong> {{ $license->branch->area->city->name ?? '-' }}</div>
        <div><strong>المنطقة التعليمية:</strong> {{ $license->branch->area->name ?? '-' }}</div>
        <div><strong>عنوان المدرسة:</strong> {{ $license->branch->school_address ?? '-' }}</div>
        <div><strong>أقرب معلم بارز:</strong> {{ $license->branch->nearest_landmark ?? '-' }}</div>
        <div><strong>الإحداثيات:</strong> {{ $license->branch->latitude ?? '-' }}, {{ $license->branch->longitude ?? '-' }}</div>
        <div><strong>مدير المدرسة:</strong> {{ $license->branch->name_manage ?? '-' }}</div>
        <div><strong>هاتف المدير:</strong> {{ $license->branch->phone_manage ?? '-' }}</div>
        <div><strong>الهاتف الثابت:</strong> {{ $license->branch->phone ?? '-' }}</div>
        <div><strong>الوصف:</strong> {{ $license->branch->description ?? '-' }}</div>
    </div>

    <!-- الملفات -->
    <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-6">

    <!-- السيرة الذاتية -->
    <div>
        <label for="cv_manage" class="block font-semibold mb-1">السيرة الذاتية للمدير</label>
        <input type="file" name="cv_manage" id="cv_manage" class="w-full border rounded p-2">
    </div>

    <!-- عقد الإيجار -->
    <div>
        <label for="contrect_image" class="block font-semibold mb-1">عقد الإيجار</label>
        <input type="file" name="contrect_image" id="contrect_image" class="w-full border rounded p-2">
    </div>

    <!-- المخطط -->
    <div>
        <label for="plan_image" class="block font-semibold mb-1">مخطط المبنى (اختياري)</label>
        <input type="file" name="plan_image" id="plan_image" class="w-full border rounded p-2">
    </div>

    <!-- الصورة الرئيسية -->
    <div>
        <label for="main_image" class="block font-semibold mb-1">الصورة الرئيسية</label>
        <input type="file" name="main_image" id="main_image" class="w-full border rounded p-2">
    </div>

    <!-- الصور الفرعية -->
    <div>
        <label for="secondary_image" class="block font-semibold mb-1">صور فرعية</label>
        <input type="file" name="secondary_image" id="secondary_image" class="w-full border rounded p-2">
    </div>

    <!-- دراسة الجدوى -->
    <div>
        <label for="file_feasibility" class="block font-semibold mb-1">دراسة الجدوى</label>
        <input type="file" name="file_feasibility" id="file_feasibility" class="w-full border rounded p-2">
    </div>

    <!-- كشف حساب بنكي -->
    <div>
        <label for="bank_statement" class="block font-semibold mb-1">كشف الحساب البنكي</label>
        <input type="file" name="bank_statement" id="bank_statement" class="w-full border rounded p-2">
    </div>

    <!-- وثائق أخرى -->
    <div>
        <label for="other_document" class="block font-semibold mb-1">وثائق أخرى</label>
        <input type="file" name="other_document" id="other_document" class="w-full border rounded p-2">
    </div>

</div>


    <!-- تعديل معلومات الترخيص -->
    <form action="{{ route('committee.licenses.updateDetails', $license->id) }}" method="POST">
        @csrf
        @method('PUT')

        <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-6">
            <div>
                <label for="status" class="block font-semibold mb-1">الحالة</label>
                <select name="status" id="status" class="w-full border rounded p-2">
                    <option value="under_review" {{ $license->status == 'under_review' ? 'selected' : '' }}>قيد المراجعة</option>
                    <option value="approved" {{ $license->status == 'approved' ? 'selected' : '' }}>مقبولة</option>
                    <option value="rejected" {{ $license->status == 'rejected' ? 'selected' : '' }}>مرفوضة</option>
                </select>
            </div>

            <div>
                <label for="current_user_id" class="block font-semibold mb-1">المستخدم الحالي</label>
                <select name="current_user_id" id="current_user_id" class="w-full border rounded p-2">
                    @foreach($users as $user)
                        <option value="{{ $user->id }}" {{ $license->current_user_id == $user->id ? 'selected' : '' }}>{{ $user->name }}</option>
                    @endforeach
                </select>
            </div>

            <div>
                <label for="next_user_id" class="block font-semibold mb-1">المستخدم التالي</label>
                <select name="next_user_id" id="next_user_id" class="w-full border rounded p-2">
                    @foreach($users as $user)
                        <option value="{{ $user->id }}" {{ $license->next_user_id == $user->id ? 'selected' : '' }}>{{ $user->name }}</option>
                    @endforeach
                </select>
            </div>

            <div class="md:col-span-2">
                <label for="note" class="block font-semibold mb-1">الملاحظات</label>
                <textarea name="note" id="note" class="w-full border rounded p-2" rows="3">{{ $license->note }}</textarea>
            </div>

            <div class="md:col-span-2">
                <label for="final_status" class="block font-semibold mb-1">الحالة النهائية</label>
                <textarea name="final_status" id="final_status" class="w-full border rounded p-2" rows="2">{{ $license->final_status }}</textarea>
            </div>

            <div>
    <label for="approval_file" class="block font-semibold mb-1">ملف الموافقة من الوزارة (PDF)</label>
    <input type="file" name="approval_file" id="approval_file" class="w-full border rounded p-2">
</div>

        </div>

        <button type="submit" class="bg-blue-600 hover:bg-blue-700 text-white px-6 py-2 rounded shadow">حفظ التعديلات</button>
    </form>
</div>
@endsection
