
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>تحديث حالة طلب الترخيص</title>
    <style>
        /* ... (نفس الأنماط السابقة) ... */
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h2>وزارة التربية والتعليم</h2>
            <h3>تحديث حالة طلب الترخيص</h3>
        </div>
        <form action="{{ route('committee.licenses.updateStatus', $license->id) }}" method="POST" enctype="multipart/form-data">
        
        <div class="content">
            <p>مرحباً،</p>
            <p>تم تحديث حالة طلب الترخيص الخاص بمدرستكم. فيما يلي تفاصيل التحديث:</p>
            
            <div class="info-item">
                <strong>اسم المدرسة:</strong> {{ $schoolName }}
            </div>
            
            <div class="info-item">
                <strong>اسم الفرع:</strong> {{ $branchName }}
            </div>
            
            <div class="info-item">
                <strong>الحالة الجديدة:</strong>
                @if($status == 'under_review')
                    قيد المراجعة
                @elseif($status == 'approved')
                    مقبول
                @elseif($status == 'rejected')
                    مرفوض
                @endif
            </div>
            
            <div class="info-item">
                <strong>الملاحظات:</strong>
                <p>{{ $note }}</p>
            </div>
            
            <div class="info-item">
                <strong>تاريخ التحديث:</strong> {{ $updatedAt }}
            </div>
            
            <p>يمكنكم تسجيل الدخول إلى النظام لمشاهدة المزيد من التفاصيل:</p>
            <a href="{{ route('client.home') }}" style="display: inline-block; background-color: #1a237e; color: white; padding: 10px 20px; text-decoration: none; border-radius: 4px;">
                تسجيل الدخول إلى النظام
            </a>
        </div>
        
        <div class="footer">
            <p>هذه الرسالة آلية، يرجى عدم الرد عليها.</p>
            <p>جميع الحقوق محفوظة © وزارة التربية والتعليم {{ date('Y') }}</p>
        </div>
    </div>
</body>
</html>
