@extends('committee.layout.master')

@section('content')
<div class="card p-4">
    <h4 class="mb-4">تفاصيل الترخيص رقم {{ $license->id }}</h4>

    <ul class="list-group">
        <li class="list-group-item"><strong>اسم الفرع:</strong> {{ $license->branch->name ?? 'غير متوفر' }}</li>
        <li class="list-group-item"><strong>الحالة:</strong>
            @switch($license->status)
                @case('under_review')
                    <span class="badge bg-warning text-dark">قيد المراجعة</span>
                    @break

                @case('approved')
                    <span class="badge bg-success">مقبول</span>
                    @break
                @case('rejected')
                    <span class="badge bg-danger">مرفوض</span>
                    @break
                @default
                    <span class="badge bg-secondary">غير معروف</span>
            @endswitch
        </li>
        <li class="list-group-item"><strong>المستخدم الحالي:</strong> {{ $license->currentUser->name ?? 'غير متوفر' }}</li>
        <li class="list-group-item"><strong>المستخدم التالي:</strong> {{ $license->nextUser->name ?? 'غير متوفر' }}</li>
        <li class="list-group-item"><strong>الملاحظة:</strong> {{ $license->note ?? '---' }}</li>
        <li class="list-group-item"><strong>الحالة النهائية:</strong> {{ $license->final_status ?? '---' }}</li>
    </ul>

    <div class="mt-4 d-flex justify-content-between">
        <a href="{{ route('committee.licenses.index') }}" class="btn btn-secondary">عودة إلى القائمة</a>
        <div>
         <a href="{{ route('committee.licenses.edit', $license->id) }}" class="btn btn-sm btn-warning">تعديل</a>
          
        </div>
    </div>
</div>
@endsection
