@extends('committee.layout.master')

@section('content')
<div class="card p-4">
    <h4 class="mb-4">قائمة التراخيص</h4>

    <table class="table table-bordered text-center">
        <thead class="table-dark">
            <tr>
                <th>الرقم</th>
                <th>اسم الفرع</th>
                <th>الحالة</th>
                <th>المستخدم الحالي</th>
                <th>المستخدم التالي</th>
                <th>الإجراءات</th>
            </tr>
        </thead>
        <tbody>
            @foreach($licenses as $license)
                <tr>
                    <td>{{ $license->id }}</td>
                    <td>{{ $license->branch->name ?? 'غير متوفر' }}</td>
                    <td>
                        @switch($license->status)
                            @case('under_review')
                                <span class="badge bg-warning text-dark">قيد المراجعة</span>
                                @break
                            @case('approved')
                                <span class="badge bg-success">مقبول</span>
                                @break
                            @case('rejected')
                                <span class="badge bg-danger">مرفوض</span>
                                @break
                            @default
                                <span class="badge bg-secondary">غير معروف</span>
                        @endswitch
                    </td>
                    <td>{{ $license->currentUser->name ?? '---' }}</td>
                    <td>{{ $license->nextUser->name ?? '---' }}</td>
                    <td>
    <a href="{{ route('committee.licenses.add', $license->id) }}" class="btn btn-sm btn-primary">عرض</a>

    <a href="{{ route('committee.licenses.edit', $license->id) }}" class="btn btn-sm btn-warning">تعديل</a>

    <form action="{{ route('committee.licenses.destroy', $license->id) }}" method="POST" style="display:inline-block;" onsubmit="return confirm('هل تريد حذف هذا الترخيص؟');">
        @csrf
        @method('DELETE')
        <button type="submit" class="btn btn-sm btn-danger">حذف</button>
    </form>
</td>

                </tr>
            @endforeach
        </tbody>
    </table>
</div>
@endsection
