@extends('committee.layout.master')

@section('content')

<div class="card p-4">

    <h4 class="mb-4">تعديل الترخيص رقم {{ $license->id }}</h4>

    <form action="{{ route('committee.licenses.update', $license->id) }}"
     method="POST"
    enctype="multipart/form-data">
        @csrf
        @method('PUT')

        {{-- الحالة --}}
        <div class="mb-3">
            <label for="status" class="form-label">الحالة</label>
            <select name="status" id="status" class="form-control" required>
                <option value="under_review" {{ $license->status == 'under_review' ? 'selected' : '' }}>قيد المراجعة</option>
                <option value="approved" {{ $license->status == 'approved' ? 'selected' : '' }}>مقبول</option>
                <option value="rejected" {{ $license->status == 'rejected' ? 'selected' : '' }}>مرفوض</option>
            </select>
        </div>

        {{-- المستخدم الحالي --}}
  <div class="col-md-6">
    <label class="form-label">المستخدم الحالي</label>
    <input type="text" class="form-control" value="{{ auth()->user()->name }}" disabled>
    <input type="hidden" name="current_user_id" value="{{ auth()->user()->id }}">
</div>


        {{-- المستخدم التالي --}}
        <div class="mb-3">
            <label for="next_user_id" class="form-label">المستخدم التالي</label>
            <select name="next_user_id" id="next_user_id" class="form-control">
                <option value="">اختر مستخدمًا</option>
                @foreach($users as $user)
                    <option value="{{ $user->id }}" {{ $license->next_user_id == $user->id ? 'selected' : '' }}>
                        {{ $user->name }}
                    </option>
                @endforeach
            </select>
        </div>

        {{-- الملاحظات --}}
        <div class="mb-3">
            <label for="note" class="form-label">ملاحظات</label>
            <textarea name="note" id="note" class="form-control">{{ $license->note }}</textarea>
        </div>

        {{-- الحالة النهائية --}}
        <div class="mb-3">
            <label for="final_status" class="form-label">الحالة النهائية</label>
            <input type="text" name="final_status" id="final_status" class="form-control" value="{{ $license->final_status }}">
        </div>


          <div class="form-group mt-3">
    <label for="approval_file">📄 ملف الموافقة (PDF من الوزارة)</label>
    <input type="file" name="approval_file" class="form-control" accept="application/pdf">

 
</div>



        <div class="d-flex justify-content-between mt-4">
            <a href="{{ route('committee.licenses.index') }}" class="btn btn-secondary">إلغاء</a>
            <button type="submit" class="btn btn-success">تحديث</button>
        </div>

    </form>

</div>

@endsection
