
@extends('committee.layout.master')

@section('title', 'طلبات تجديد التراخيص')

@section('content')
<div class="container py-4">

    {{-- عنوان الصفحة --}}
    <h2 class="mb-4">طلبات تجديد الترخيص</h2>

    {{-- تنبيه نجاح --}}
    @if(session('success'))
        <div class="alert alert-success">
            {{ session('success') }}
        </div>
    @endif

    {{-- لا توجد بيانات --}}
    @if($renewals->isEmpty())
        <div class="alert alert-info">
            لا توجد طلبات تجديد ترخيص حتى الآن.
        </div>
    @else
        <div class="table-responsive">
            <table class="table table-bordered align-middle text-center">
                <thead class="table-light">
                    <tr>
                        <th>الرقم</th>
                        <th>اسم المدرسة</th>
                        <th>الفرع</th>
                        <th>المديرية</th>
                        <th>الحالة</th>
                        <th>خيارات</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($renewals as $index => $renwel)
                        <tr>
                            <td>{{ $index + 1 }}</td>
                            <td>{{ $renwel->school->school_name ?? '-' }}</td> <!-- إظهار اسم المدرسة -->
                      <td>{{ $renwel->branch_name ?? '-' }}</td> <!-- إظهار الفرع كاسم -->
                     <td>{{ $renwel->area->name ?? '-' }}</td>
                            <td>
                                @switch($renwel->status)
                                    @case('مقبول')
                                        <span class="badge bg-success">مقبول</span>
                                        @break
                                    @case('مرفوض')
                                        <span class="badge bg-danger">مرفوض</span>
                                        @break
                                    @default
                                        <span class="badge bg-warning text-dark">قيد المراجعة</span>
                                @endswitch
                            </td>
                            <td>
                                <a href="{{ route('committee.show', $renwel->id) }}" class="btn btn-sm btn-primary">
                                    <i class="fas fa-eye"></i> عرض
                                </a>
                                  <form action="{{ route('committee.renwels.destroy', $renwel->id) }}" method="POST" style="display:inline-block;" 
          onsubmit="return confirm('هل أنت متأكد من الحذف؟');">
        @csrf
        @method('DELETE')
        <button type="submit" class="btn btn-sm btn-danger">
            <i class="fas fa-trash-alt"></i> حذف
        </button>
    </form>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    @endif

</div>
@endsection
