<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>لوحة تحكم اللجنة</title>
    
    <!-- Bootstrap RTL -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.rtl.min.css" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <style>
        :root {
            --primary-dark: #002b55;
            --primary: #003366;
            --primary-light: #004080;
            --secondary: #f5b041;
            --light: #f8f9fa;
            --dark: #212529;
            --success: #28a745;
            --danger: #dc3545;
            --warning: #ffc107;
            --info: #17a2b8;
            --transition: all 0.3s ease;
        }
        
        body {
            background: linear-gradient(135deg, #f4f6f9, #e9ecef);
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            color: #333;
            margin: 0;
            min-height: 100vh;
        }
        
        .topbar {
            position: fixed;
            top: 0;
            right: 0;
            left: 0;
            height: 70px;
            background: linear-gradient(to right, var(--primary-dark), var(--primary));
            color: white;
            display: flex;
            align-items: center;
            padding: 0 25px;
            z-index: 1000;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
            border-bottom: 3px solid var(--secondary);
        }
        
        .topbar h5 {
            font-weight: 700;
            margin-bottom: 0;
            text-shadow: 0 1px 3px rgba(0, 0, 0, 0.3);
            position: relative;
            padding-right: 40px;
        }
        
        .topbar h5::before {
            content: '';
            position: absolute;
            right: 0;
            top: 50%;
            transform: translateY(-50%);
            width: 30px;
            height: 30px;
            background: url('data:image/svg+xml;utf8,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="white"><path d="M12 14l9-5-9-5-9 5 9 5z"/><path d="M12 14l6.16-3.422a12.083 12.083 0 01.665 6.479A11.952 11.952 0 0012 20.055a11.952 11.952 0 00-6.824-2.998 12.078 12.078 0 01.665-6.479L12 14z"/></svg>');
            background-size: contain;
        }
        
        .sidebar {
            width: 280px;
            background: linear-gradient(to bottom, var(--primary), var(--primary-light));
            color: white;
            position: fixed;
            top: 70px;
            right: 0;
            bottom: 0;
            padding: 25px 15px;
            overflow-y: auto;
            box-shadow: 3px 0 10px rgba(0, 0, 0, 0.2);
            z-index: 999;
        }
        
        .sidebar h4 {
            font-size: 24px;
            margin-bottom: 25px;
            font-weight: 700;
            text-align: center;
            position: relative;
            padding-bottom: 15px;
        }
        
        .sidebar h4::after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 50%;
            transform: translateX(-50%);
            width: 60px;
            height: 3px;
            background: var(--secondary);
            border-radius: 2px;
        }
        
        .sidebar a {
            color: #f1f1f1;
            display: flex;
            align-items: center;
            margin: 15px 0;
            padding: 12px 15px;
            border-radius: 8px;
            transition: var(--transition);
            text-decoration: none;
            font-size: 17px;
            font-weight: 500;
            background: rgba(255, 255, 255, 0.05);
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.05);
        }
        
        .sidebar a i {
            width: 30px;
            text-align: center;
            margin-left: 10px;
            font-size: 20px;
            color: var(--secondary);
        }
        
        .sidebar a:hover {
            background: rgba(255, 255, 255, 0.15);
            transform: translateX(-5px);
            border-right: 3px solid var(--secondary);
        }
        
        .main-content {
            margin-right: 300px;
            margin-top: 90px;
            padding: 30px;
            background-color: #fff;
            border-radius: 12px;
            box-shadow: 0 6px 20px rgba(0, 0, 0, 0.08);
            min-height: calc(100vh - 150px);
            position: relative;
            overflow: hidden;
            border: 1px solid #eaeaea;
        }
        
        .main-content::before {
            content: '';
            position: absolute;
            top: 0;
            right: 0;
            width: 100%;
            height: 4px;
            background: linear-gradient(to right, var(--secondary), var(--primary));
        }
        
        footer {
            background: linear-gradient(to right, var(--primary-dark), var(--primary));
            color: white;
            padding: 18px;
            text-align: center;
            position: fixed;
            bottom: 0;
            right: 0;
            width: 100%;
            font-size: 16px;
            z-index: 998;
            border-top: 2px solid var(--secondary);
            font-weight: 500;
        }
        
        .btn-logout {
            background: linear-gradient(135deg, #c0392b, #a93226);
            border: none;
            border-radius: 8px;
            padding: 12px;
            font-weight: 600;
            font-size: 17px;
            margin-top: 30px;
            width: 100%;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.15);
            transition: var(--transition);
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        .btn-logout i {
            margin-left: 10px;
            font-size: 20px;
        }
        
        .btn-logout:hover {
            transform: translateY(-3px);
            box-shadow: 0 6px 12px rgba(0, 0, 0, 0.2);
            background: linear-gradient(135deg, #a93226, #922b21);
        }
        
        /* تأثيرات للشريط الجانبي عند التمرير */
        .sidebar::-webkit-scrollbar {
            width: 8px;
        }
        
        .sidebar::-webkit-scrollbar-track {
            background: rgba(255, 255, 255, 0.1);
            border-radius: 4px;
        }
        
        .sidebar::-webkit-scrollbar-thumb {
            background: var(--secondary);
            border-radius: 4px;
        }
        
        /* تصميم متجاوب */
        @media (max-width: 992px) {
            .sidebar {
                width: 230px;
            }
            
            .main-content {
                margin-right: 250px;
            }
        }
        
        @media (max-width: 768px) {
            .sidebar {
                width: 70px;
                padding: 20px 5px;
                overflow: visible;
            }
            
            .sidebar h4, .sidebar span {
                display: none;
            }
            
            .sidebar a {
                justify-content: center;
                padding: 15px 10px;
                margin: 20px 0;
                position: relative;
            }
            
            .sidebar a i {
                margin: 0;
                font-size: 24px;
            }
            
            .sidebar a:hover::after {
                content: attr(title);
                position: absolute;
                right: 100%;
                top: 50%;
                transform: translateY(-50%);
                background: var(--primary);
                color: white;
                padding: 8px 15px;
                border-radius: 6px;
                white-space: nowrap;
                font-size: 14px;
                box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
                z-index: 1000;
            }
            
            .main-content {
                margin-right: 90px;
                padding: 20px;
            }
            
            .btn-logout span {
                display: none;
            }
        }
    </style>
</head>

<body>
    <!-- الشريط العلوي -->
    <div class="topbar">
        <h5>وزارة التربية والتعليم - اللجنة</h5>
    </div>

    <!-- الشريط الجانبي -->
    <div class="sidebar">
        <h4>لوحة اللجنة</h4>
        
        <a href="{{ route('committee.dashboard') }}" title="الرئيسية">
            <i class="fas fa-home"></i>
            <span>الرئيسية</span>
        </a>
        <a href="{{ route('committee.licenses.index') }}" title="عرض التراخيص">
            <i class="fas fa-file-alt"></i>
            <span>عرض التراخيص</span>
        </a>
    <a href="{{ route('committee.city') }}" title="تجديد للمحافظات">
            <i class="fas fa-file-alt"></i>
            <span>التجديد للمحافظات</span>
        </a>
      


    <a href="{{ route('committee.renwels.index') }}" title="تجديد التراخيص">
            <i class="fas fa-file-alt"></i>
            <span>تجديد التراخيص</span>
        </a>






        <form id="logout-form" method="POST" action="{{ route('logout') }}">
            @csrf
            <button type="submit" class="btn btn-logout" onclick="return confirmLogout()">
                <i class="fas fa-sign-out-alt"></i>
                <span>تسجيل الخروج</span>
            </button>
        </form>
    </div>

    <!-- المحتوى الرئيسي -->
    <div class="main-content">
        @yield('content')
    </div>

    <!-- الفوتر -->
    <footer
