@extends('committee.layout.master')

@section('content')
<div class="container mt-4">
    <h2 class="mb-4 text-white">طلبات تجديد التراخيص حسب المحافظة</h2>

    <div class="row">
        @foreach($data as $city)
        <div class="col-md-3 mb-4">
            <a href="{{ route('committee.city.byCity', $city->id) }}" style="text-decoration: none;">
                <div class="card h-100 text-white" style="background: linear-gradient(135deg, #0b2545 0%, #162a69 70%); border: 2px solid #d4af37; border-radius: 12px;">
                    <div class="card-body d-flex flex-column justify-content-center align-items-center">
                        <h5 class="card-title" style="color: #d4af37; font-weight: bold;">{{ $city->name }}</h5>
                        <p class="card-text display-4" style="color: white; font-weight: 700;">{{ $city->renewals_count }}</p>
                        <p style="color: #d4af37;">طلبات تجديد</p>
                    </div>
                </div>
            </a>
        </div>
        @endforeach
    </div>
</div>
@endsection
