@extends('committee.layout.master')
@section('content')
<div class="container mt-4">
    <div class="card shadow border-0">
        <div class="card-header bg-primary text-white py-3">
            <h4 class="mb-0 fw-bold">
                <i class="fas fa-map-marker-alt me-2"></i>
                طلبات التراخيص في محافظة
            </h4>
        </div>
        
        <div class="card-body">
           @if ($licenses->isEmpty())
    <div class="alert alert-info text-center p-4 fs-5 rounded-3">
        <i class="fas fa-info-circle me-2"></i>
        لا توجد طلبات تراخيص في  هذه المحافظة {{ $city->name ?? 'غير معروفة' }}
    </div>
@else

                <div class="table-responsive">
                    <table class="table table-bordered table-striped table-hover">
                        <thead class="table-light">
                            <tr>
                                <th class="py-3">الرقم</th>
                                <th class="py-3">اسم المدرسة</th>
                                <th class="py-3">اسم الفرع</th>
                                <th class="py-3">الحالة</th>
                                <th class="py-3">الملاحظات</th>
                                <th class="py-3">تاريخ الطلب</th>
                                <th class="py-3">الإجراءات</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($licenses as $license)
                            <tr>
                                <td class="py-3">{{ $loop->iteration }}</td>
                                <td class="py-3">{{ $license->branch->school->school_name ?? 'غير معروف' }}</td>
                                <td class="py-3">{{ $license->branch->name ?? 'غير معروف' }}</td>
                                <td class="py-3">
                                    @switch($license->status)
                                        @case('under_review')
                                            <span class="badge bg-warning text-dark">قيد المراجعة</span>
                                        @break
                                        @case('approved')
                                            <span class="badge bg-success">مقبول</span>
                                        @break
                                        @case('rejected')
                                            <span class="badge bg-danger">مرفوض</span>
                                        @break
                                        @default
                                            <span class="badge bg-secondary">{{ $license->status }}</span>
                                    @endswitch
                                </td>
                                <td class="py-3">{{ $license->note ?? '-' }}</td>
                                <td class="py-3">{{ $license->created_at->format('Y-m-d') }}</td>
                                <td class="py-3">
                                    <a href="{{ route('committee.licenses.add', $license->id) }}" 
                                       class="btn btn-info btn-sm">
                                       <i class="fas fa-eye me-1"></i> عرض
                                    </a>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            @endif
        </div>
    </div>
</div>
@endsection
