
@extends('client.layout')
 
@section('title', 'نتيجة تتبع الطلب')
 
@push('styles')
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
@endpush
 
@section('content')

 

<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>نتيجة تتبع الطلب</title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        :root {
            --dark-blue: #0d2b50;
            --gold: #d4af37;
        }
        
        .card {
            border: 3px solid var(--gold);
            border-radius: 0;
            position: relative;
        }
        
        .card::before,
        .card::after {
            content: '';
            position: absolute;
            width: 20px;
            height: 20px;
            border: 2px solid var(--gold);
        }
        
        .card::before {
            top: -2px;
            left: -2px;
            border-right: none;
            border-bottom: none;
        }
        
        .card::after {
            bottom: -2px;
            right: -2px;
            border-left: none;
            border-top: none;
        }
        
        .card-header {
            background: var(--dark-blue);
            border-bottom: 3px solid var(--gold);
        }
        
        .table thead th {
            background: var(--dark-blue);
            color: var(--gold);
            border: 1px solid var(--gold);
        }
        
        .table tbody td {
            border: 1px solid rgba(212, 175, 55, 0.2);
        }
        
        .btn-outline-success {
            border-color: var(--dark-blue);
            color: var(--dark-blue);
        }
    </style>
</head>
<body>
    <div class="container mt-5" style="font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif">
        <div class="card border-0 shadow">
            <div class="card-header text-white py-3">
                <h3 class="mb-0 text-center">نتائج تتبع الطلبات الخاصة بك</h3>
            </div>

            {{-- قسم الترخيص --}}
            <div id="license-section">
                @if($branches->isNotEmpty())
                   <div class="card-body p-0">
                <div id="license-section">
                    <div class="table-responsive">
                        <table class="table table-hover table-bordered align-middle mb-0">
                            <thead class="table-light">
                                <tr>
                                    <th>اسم المدرسة</th>
                                    <th>اسم الفرع</th>
                                    <th>المنطقة</th>
                                    <th>الحالة</th>
                                    <th>الملاحظة</th>
                                    <th>ملف الموافقة</th>
                                </tr>
                            </thead>
                            <tbody>
                                

                                @foreach ($branches as $branch)
                                    @php $license = $branch->licenses->first(); @endphp
                                    <tr class="{{ $loop->odd ? 'table-default' : '' }}">
                                        <td class="fw-medium">{{ $branch->school->school_name ?? '-' }}</td>
                                        <td>{{ $branch->name ?? '-' }}</td>
                                        <td>{{ $branch->area->name ?? 'غير محددة' }}</td>
                                        <td>
                                            @if($license)
                                                @switch($license->status)
                                                    @case('under_review')
                                                        <span class="badge bg-warning text-dark p-2"><i class="fas fa-clock me-1"></i> قيد المراجعة</span>
                                                        @break
                                                    @case('approved')
                                                        <span class="badge bg-success p-2"><i class="fas fa-check-circle me-1"></i> مقبول</span>
                                                        @break
                                                    @case('rejected')
                                                        <span class="badge bg-danger p-2"><i class="fas fa-times-circle me-1"></i> مرفوض</span>
                                                        @break
                                                    @default
                                                        <span class="badge bg-secondary p-2">-</span>
                                                @endswitch
                                            @else
                                                <span class="badge bg-secondary p-2">لا يوجد ترخيص</span>
                                            @endif
                                        </td>
                                        <td class="text-muted">{{ $license?->note ?? '-' }}</td>
                                        <td>
                                            @if($license && $license->status === 'approved' && $license->final_status && $license->approval_file)
                                                <a href="{{ asset('storage/' . $license->approval_file) }}" class="btn btn-sm btn-outline-success" target="_blank">
                                                    <i class="fas fa-file-pdf me-1"></i> عرض الملف
                                                </a>
                                            @else
                                                <span class="text-muted fst-italic">غير متاح</span>
                                            @endif
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                @else
                    <div class="alert alert-info text-center py-3 fs-5">
                        <i class="fas fa-info-circle me-2"></i> لا توجد فروع حالياً
                    </div>
                @endif
            </div>
 
 
@endsection
