@extends('client.layout')

@section('title', 'نتائج تجديد التراخيص')

@section('content')
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>نتيجة تتبع الطلب</title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        :root {
            --dark-blue: #0d2b50;
            --gold: #d4af37;
        }
        
        .card {
            border: 3px solid var(--gold);
            border-radius: 0;
            position: relative;
        }
        
        .card::before,
        .card::after {
            content: '';
            position: absolute;
            width: 20px;
            height: 20px;
            border: 2px solid var(--gold);
        }
        
        .card::before {
            top: -2px;
            left: -2px;
            border-right: none;
            border-bottom: none;
        }
        
        .card::after {
            bottom: -2px;
            right: -2px;
            border-left: none;
            border-top: none;
        }
        
        .card-header {
            background: var(--dark-blue);
            border-bottom: 3px solid var(--gold);
        }
        
        .table thead th {
            background: var(--dark-blue);
            color: var(--gold);
            border: 1px solid var(--gold);
        }
        
        .table tbody td {
            border: 1px solid rgba(212, 175, 55, 0.2);
        }
        
        .btn-outline-success {
            border-color: var(--dark-blue);
            color: var(--dark-blue);
        }
    </style>
<div class="container mt-4">
    <h2 class="mb-4">نتائج تجديد التراخيص</h2>

    <table class="table table-bordered table-striped">
        <thead class="table-primary">
            <tr>
                <th>اسم المدرسة</th>
                <th>اسم الفرع</th>
                <th>المديرية</th>
                <th>الحالة</th>
                <th>الملاحظات</th>
                <th>ملف الموافقة</th>
            </tr>
        </thead>
        <tbody>
            @forelse ($renewals as $renewal)
                <tr>
                    <td>{{ $renewal->school ? $renewal->school->school_name : '-' }}</td>
                    <td>{{ $renewal->branch_name }}</td>
                    <td>{{ $renewal->area ? $renewal->area->name : '-' }}</td>
                    <td>
                       @if( $renewal )

                        @switch($renewal->status)
                                                    @case('قيد المراجعة')
                                                        <span class="badge bg-secondary"><i class="fas fa-clock me-1"></i> قيد المراجعة</span>
                                                        @break
                                                    @case('مقبول')
                                                        <span class="badge bg-success p-2"><i class="fas fa-check-circle me-1"></i> مقبول</span>
                                                        @break
                                                    @case('مرفوض')
                                                        <span class="badge bg-danger p-2"><i class="fas fa-times-circle me-1"></i> مرفوض</span>
                                                        @break
                                                    @default
                                                        <span class="badge bg-secondary p-2">-</span>
                                                @endswitch
                                            @else
                                                <span class="badge bg-secondary p-2">لا يوجد </span>
                                            @endif
                                        </td>
                    
                    <td>{{ $renewal->notes ?? '-' }}</td>
                    <td>
                        @if ($renewal->status === 'مقبول' && $renewal->admin_document)
                        <span class="badge bg-success p-2"><i class="fas fa-check-circle me-1"></i>
                            <a href="{{ asset('storage/' . $renewal->admin_document) }}" target="_blank" class="btn btn-sm btn-success">عرض الملف</a>
                        @else
                            -
                        @endif
                    </td>
                </tr>
            @empty
                <tr>
                    <td colspan="6" class="text-center">لا توجد نتائج حالياً</td>
                </tr>
            @endforelse
        </tbody>
    </table>
</div>
@endsection
