
@extends('client.layout')

@section('content')
<div class="container py-5">
    <div class="row justify-content-center">
        <div class="col-lg-8">
            <div class="success-card" style="
                background: white;
                border-radius: 15px;
                overflow: hidden;
                box-shadow: 0 10px 30px rgba(0,0,0,0.15);
                border: none;
            ">
                <div class="success-header" style="
                    background: linear-gradient(135deg, #1e5799, #207cca);
                    color: white;
                    padding: 20px 30px;
                    display: flex;
                    align-items: center;
                    font-size: 1.3rem;
                ">
                    <i class="fas fa-check-circle me-3"></i>
                    <span>تمت العملية بنجاح</span>
                </div>

                <div class="success-body text-center py-5 px-4" style="
                    background: linear-gradient(to bottom, #f8faff, #ffffff);
                    padding: 40px 20px;
                ">
                    <div class="success-icon mb-4" style="
                        width: 120px;
                        height: 120px;
                        background: linear-gradient(135deg, #4CAF50, #2E7D32);
                        border-radius: 50%;
                        display: inline-flex;
                        align-items: center;
                        justify-content: center;
                        box-shadow: 0 8px 20px rgba(76, 175, 80, 0.3);
                    ">
                        <i class="fas fa-check fa-3x text-white"></i>
                    </div>
                    
                    <h2 class="mb-3 fw-bold" style="color: #2c3e50;">تم تقديم طلب تجديد الترخيص بنجاح</h2>
                    
                    <p class="lead mb-4 px-lg-5" style="
                        color: #555;
                        font-size: 1.25rem;
                        line-height: 1.6;
                    ">
                        سيتم مراجعة طلبك من قبل فريق الوزارة وسيتم إعلامك بالنتيجة عبر البريد الإلكتروني.
                    </p>
                    
                    <div class="success-progress mt-5 mb-4 mx-auto" style="
                        width: 80%;
                        height: 8px;
                        background: #e9ecef;
                        border-radius: 10px;
                        overflow: hidden;
                        position: relative;
                    ">
                        <div style="
                            width: 100%;
                            height: 100%;
                            background: linear-gradient(to right, #4CAF50, #2E7D32);
                            animation: progress 2s ease-in-out;
                        "></div>
                    </div>
                    
                    <div class="d-flex flex-column flex-md-row justify-content-center gap-3 mt-5">
                        <a href="{{ route('renew.create') }}" class="btn btn-primary btn-lg py-3 px-4" style="
                            background: linear-gradient(to right, #1e5799, #207cca);
                            border: none;
                            border-radius: 50px;
                            font-weight: 600;
                            box-shadow: 0 5px 15px rgba(30, 87, 153, 0.3);
                            transition: all 0.3s;
                        ">
                            <i class="fas fa-plus-circle me-2"></i> تقديم طلب جديد
                        </a>
                        
                        <a href="{{ route('client.home') }}" class="btn btn-outline-secondary btn-lg py-3 px-4" style="
                            border: 2px solid #1e5799;
                            border-radius: 50px;
                            color: #1e5799;
                            font-weight: 600;
                            transition: all 0.3s;
                        ">
                            <i class="fas fa-home me-2"></i> العودة للصفحة الرئيسية
                        </a>
                    </div>
                    
                    <div class="mt-5 pt-3 text-muted" style="border-top: 1px solid #eee;">
                    
                        <p>تاريخ التقديم: {{ now()->format('Y-m-d') }}</p>
                    </div>
                </div>
            </div>
            
            <div class="mt-5 text-center">
                <div class="support-card p-4" style="
                    background: #fff;
                    border-radius: 12px;
                    box-shadow: 0 5px 15px rgba(0,0,0,0.05);
                    max-width: 600px;
                    margin: 0 auto;
                ">
                    <h4 class="mb-3" style="color: #1e5799;">هل تحتاج مساعدة؟</h4>
                    <p class="mb-4">فريق اللجنة جاهز للإجابة على استفساراتك على مدار الساعة</p>
                    <div class="d-flex justify-content-center gap-3">
                        <a href="#" class="btn btn-outline-primary d-flex align-items-center" style="
                            border-radius: 50px;
                            padding: 8px 20px;
                        ">
                            <i class="fas fa-phone-alt me-2"></i> 777777777
                        </a>
                        <a href="#" class="btn btn-outline-success d-flex align-items-center" style="
                            border-radius: 50px;
                            padding: 8px 20px;
                        ">
                            <i class="fas fa-envelope me-2"></i> committee_yemen@edu.ye
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    .btn-primary:hover {
        transform: translateY(-3px);
        box-shadow: 0 8px 20px rgba(30, 87, 153, 0.4);
    }
    
    .btn-outline-secondary:hover {
        background: linear-gradient(to right, #1e5799, #207cca);
        color: white !important;
    }
    
    @keyframes progress {
        0% { width: 0%; }
        100% { width: 100%; }
    }
    
    @media (max-width: 768px) {
        .success-body {
            padding: 30px 15px !important;
        }
        
        .d-flex.flex-md-row {
            flex-direction: column;
        }
        
        .btn-lg {
            width: 100%;
            margin-bottom: 10px;
        }
    }
</style>
@endsection
