@extends('client.layout')


@section('title', 'إضافة مدرسة')

@section('content')
<div class="container mt-4">
    <h2 class="mb-4">إضافة مدرسة جديدة</h2>

    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif

    @if ($errors->any())
        <div class="alert alert-danger">
            <ul class="mb-0">
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <form action="{{ route('schools.store') }}" method="POST" enctype="multipart/form-data">
        @csrf

        <div class="mb-3">
            <label>اسم المدرسة</label>
            <input type="text" name="school_name" class="form-control" value="{{ old('school_name') }}" required>
        </div>

        <div class="mb-3">
            <label>المحافظة</label>
            <select name="city_id" class="form-control" required>
                <option value="">اختر المحافظة</option>
                @foreach($cities as $city)
                    <option value="{{ $city->id }}" {{ old('city_id') == $city->id ? 'selected' : '' }}>
                        {{ $city->name }}
                    </option>
                @endforeach
            </select>
        </div>

        <div class="mb-3">
            <label>نوع المدرسة</label>
           <div class="form-check">
    <input class="form-check-input" type="checkbox" name="type[]" value="تمهيدي" id="type1">
    <label class="form-check-label" for="type1">تمهيدي</label>
</div>

<div class="form-check">
    <input class="form-check-input" type="checkbox" name="type[]" value="أساسي" id="type2">
    <label class="form-check-label" for="type2">أساسي</label>
</div>

<div class="form-check">
    <input class="form-check-input" type="checkbox" name="type[]" value="إعدادي" id="type3">
    <label class="form-check-label" for="type3">إعدادي</label>
</div>

<div class="form-check">
    <input class="form-check-input" type="checkbox" name="type[]" value="ثانوي" id="type4">
    <label class="form-check-label" for="type4">ثانوي</label>
</div>


      <div class="mb-4">
                    <label for="logo" class="form-label fw-bold">شعار المدرسة (صورة)</label>
                    <input type="file" id="logo" name="logo" class="form-control">
                </div>

        <button type="submit" class="btn btn-success">حفظ</button>
    </form>
</div>
@endsection
