




















<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>نظام تجديد التراخيص المدرسية</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root {
            --primary: #1e5799;
            --secondary: #2c3e50;
            --success: #28a745;
            --warning: #ffc107;
            --danger: #dc3545;
            --light: #f8f9fa;
            --dark: #343a40;
        }
        
        body {
            background-color: #f5f7fa;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            color: #333;
            line-height: 1.6;
        }
        
        .header-bar {
            background: linear-gradient(135deg, var(--primary), #207cca);
            color: white;
            padding: 15px 0;
            box-shadow: 0 4px 12px rgba(0,0,0,0.1);
        }
        
        .step-card {
            background: white;
            border-radius: 10px;
            box-shadow: 0 4px 15px rgba(0,0,0,0.08);
            margin-bottom: 25px;
            overflow: hidden;
        }
        
        .step-header {
            background: linear-gradient(135deg, var(--secondary), #4a6582);
            color: white;
            padding: 15px 20px;
            font-weight: 600;
            display: flex;
            align-items: center;
        }
        
        .step-header i {
            margin-left: 10px;
            font-size: 1.3rem;
        }
        
        .step-body {
            padding: 25px;
        }
        
        .document-item {
            border-left: 3px solid var(--primary);
            padding: 15px 20px;
            margin-bottom: 25px;
            background-color: #f8faff;
            border-radius: 0 8px 8px 0;
            transition: all 0.3s;
        }
        
        .document-item:hover {
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
            transform: translateY(-3px);
        }
        
        .document-icon {
            width: 50px;
            height: 50px;
            background: linear-gradient(135deg, var(--primary), #3a7bd5);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 1.5rem;
            margin-left: 15px;
        }
        
        .btn-download {
            background: linear-gradient(to right, var(--success), #1e7e34);
            color: white;
            border: none;
            padding: 8px 15px;
            border-radius: 5px;
            display: inline-flex;
            align-items: center;
            transition: all 0.3s;
        }
        
        .btn-download:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(40, 167, 69, 0.3);
        }
        
        .btn-download i {
            margin-left: 5px;
        }
        
    
        
        .stat-item {
            background: white;
            border-radius: 8px;
            padding: 20px;
            box-shadow: 0 3px 10px rgba(0,0,0,0.05);
            margin-bottom: 15px;
            position: relative;
        }
        
        .stat-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 15px;
        }
        
        .download-stat-btn {
            background: var(--primary);
            color: white;
            border: none;
            padding: 6px 12px;
            border-radius: 4px;
            font-size: 0.9rem;
            display: inline-flex;
            align-items: center;
        }
        
        .download-stat-btn i {
            margin-left: 5px;
        }
        
        .footer {
            background: var(--dark);
            color: white;
            padding: 25px 0;
            margin-top: 40px;
        }
        
        .form-check-input:checked {
            background-color: var(--primary);
            border-color: var(--primary);
        }
        
        .btn-primary {
            background: linear-gradient(to right, var(--primary), #3a7bd5);
            border: none;
            padding: 10px 25px;
            font-weight: 600;
        }
        
        .btn-secondary {
            background: linear-gradient(to right, #6c757d, #5a6268);
            border: none;
            padding: 10px 25px;
            font-weight: 600;
        }
        
        .alert {
            border-radius: 8px;
        }
        
        @media (max-width: 768px) {
            .d-flex.align-items-center {
                flex-direction: column;
                align-items: flex-start !important;
            }
            
            .btn-download {
                margin-top: 15px;
                width: 100%;
                justify-content: center;
            }
        }
    </style>
</head>
<body>
    <div class="header-bar">
        <div class="container">
            <h1 class="text-center"><i class="fas fa-school me-2"></i>نظام تجديد التراخيص المدرسية</h1>
        </div>
    </div>

    <div class="container my-5">
        <div class="step-card">
            <div class="step-header">
                <i class="fas fa-file-alt"></i>
                <span>نموذج تجديد الترخيص</span>
            </div>
            
            <div class="step-body">
                @if(session('success'))
                    <div class="alert alert-success">
                        {{ session('success') }}
                    </div>
                @endif
                
                @if($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif
                
                <form method="POST" action="{{ route('renew.store') }}" enctype="multipart/form-data">
                    @csrf
                  <!-- معلومات المدرسة -->
<div class="step-card mb-4">
    <div class="step-header">
        <i class="fas fa-school"></i>
        <span>معلومات المدرسة</span>
    </div>
    <div class="step-body">
        <div class="mb-4">
            <h5 class="border-bottom pb-2">اختر المدرسة</h5>
            <select name="school_id" class="form-control" required id="schoolSelect">
                <option value="">اختر المدرسة</option>
                @foreach($schools as $school)
                <option value="{{ $school->id }}" 
                    data-branch="{{ $school->branch_name }}"
                    data-area="{{ $school->area_id }}"
                    {{ old('school_id') == $school->id ? 'selected' : '' }}>
                    {{ $school->school_name }}
                </option>
                @endforeach
            </select>
            
            @error('school_id')
                <div class="text-danger mt-2">{{ $message }}</div>
            @enderror
            
            @if($schools->isEmpty())
                <div class="mt-3 text-center text-danger p-3 bg-light rounded">
                    <i class="fas fa-exclamation-circle me-2"></i>
                    لا تملك أي مدارس مسجلة. يرجى 
                    <a href="{{ route('schools.create') }}" class="fw-bold text-danger">
                        إضافة مدرسة جديدة
                    </a>
                </div>
            @endif
        </div>

                            
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label class="form-label required-label">اسم الفرع</label>
                                    <input type="text" class="form-control" name="branch_name" required>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label required-label">المديرية</label>
                                    <select class="form-select" name="area_id" required>
                                        <option value="">اختر المديرية</option>
                                        @foreach($areas as $area)
                                            <option value="{{ $area->id }}">{{ $area->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label required-label">الأقسام</label>
                                    <div>
                                        <div class="form-check form-check-inline">
                                            <input class="form-check-input" type="checkbox" name="sections[]" value="عربي" id="arabic">
                                            <label class="form-check-label" for="arabic">عربي</label>
                                        </div>
                                        <div class="form-check form-check-inline">
                                            <input class="form-check-input" type="checkbox" name="sections[]" value="إنجليزي" id="english">
                                            <label class="form-check-label" for="english">إنجليزي</label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- المستندات الأساسية -->
                    <div class="step-card mb-4">
                        <div class="step-header">
                            <i class="fas fa-file-contract"></i>
                            <span>المستندات الأساسية</span>
                        </div>
                        <div class="step-body">
                            <!-- وثائق المعلمين -->
                            <div class="document-item">
                                <div class="d-flex align-items-center mb-3">
                                    <div class="document-icon">
                                        <i class="fas fa-chalkboard-teacher"></i>
                                    </div>
                                    <div class="flex-grow-1">
                                        <h5 class="mb-1">وثائق المعلمين الأشقاء والغير اشقاء</h5>
                                        <p class="mb-0 text-muted">يجب أن تشمل: الشهادات العلمية، عقد العمل   </p>
                                    </div>
                                      <a href="{{ route('download.teacher.report') }}"     class="btn btn-outline-primary mt-3">
                           <i class="fas fa-file-word me-2"></i> تحميل كشف المعلمين

                                    </a>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label required-label">رفع ملف وثائق المعلمين</label>
                                    <input type="file" class="form-control" name="teachers_documents" accept=".pdf,.jpg,.jpeg,.png" required>
                                    <div class="form-text">PDF, JPG, PNG (الحد الأقصى 5MB)</div>
                                </div>
                            </div>
                            
                            <!-- استمارة تجديد الترخيص -->
                            <div class="document-item">
                                <div class="d-flex align-items-center mb-3">
                                    <div class="document-icon">
                                        <i class="fas fa-file-signature"></i>
                                    </div>
                                    <div class="flex-grow-1">
                                        <h5 class="mb-1">استمارة طلب تجديد الترخيص</h5>
                                    </div>
                                    <a href="{{ route('download.renewal') }}" 
                                        class="btn btn-outline-primary mt-3">
                           <i class="fas fa-file-word me-2"></i> تحميل استمارة التجديد
                                     </a>

                                </div>
                                <div class="mb-3">
                                    <label class="form-label required-label">رفع الاستمارة</label>
                                    <input type="file" class="form-control" name="renewal_form" accept=".pdf,.jpg,.jpeg,.png" required>
                                    <div class="form-text">PDF, JPG, PNG (الحد الأقصى 5MB)</div>
                                </div>
                            </div>
                            
                            <!-- صورة المدير -->
                            <div class="document-item">
                                <div class="d-flex align-items-center mb-3">
                                    <div class="document-icon">
                                        <i class="fas fa-user-tie"></i>
                                    </div>
                                    <div class="flex-grow-1">
                                        <h5 class="mb-1">صورة شخصية للمالك</h5>
                                        <p class="mb-0 text-muted">بخلفية بيضاء - مقاس 4×6</p>
                                    </div>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label required-label">رفع صورة المدير</label>
                                    <input type="file" class="form-control" name="director_image" accept=".jpg,.jpeg,.png" required>
                                    <div class="form-text">JPG, PNG فقط (الحد الأقصى 2MB)</div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- المستندات المالية -->

                    
                    <div class="step-card mb-4">
                        <div class="step-header">
                            <i class="fas fa-file-invoice-dollar"></i>
                            <span>المستندات المالية</span>
                        </div>
                        <div class="step-body">
                                              <div class="flex-grow-1">
                                        <h5 class="mb-1"> المستندات المالية تكون بهذاالشكل</h5>
                                        <!-- <p class="mb-0 text-muted">يجب أن تشمل: الشهادات العلمية، عقد العمل،  </p> -->
                                    </div>
                                      <a href="{{ route('bank') }}"     class="btn btn-outline-primary mt-3">
                           <i class="fas fa-file-word me-2"></i> تحميل المستندات المالية

                                    </a><br>
                            <!-- سند شراء شهادات الطلاب -->
                             
                            <div class="document-item">
                                <div class="d-flex align-items-center mb-3">
                                    <div class="document-icon">
                                        <i class="fas fa-receipt"></i>
                                    </div>
                                    <div class="flex-grow-1">
                                        <h5 class="mb-1">سند شراء شهادات الطلاب</h5>
                                    </div>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label required-label">رفع السند</label>
                                    <input type="file" class="form-control" name="certificate_purchase_receipt" accept=".pdf,.jpg,.jpeg,.png" required>
                                    <div class="form-text">PDF, JPG, PNG (الحد الأقصى 5MB)</div>
                                </div>
                            </div>
                            
                            <!-- سند الأشغال -->
                            <div class="document-item">
                                <div class="d-flex align-items-center mb-3">
                                    <div class="document-icon">
                                        <i class="fas fa-tools"></i>
                                    </div>
                                    <div class="flex-grow-1">
                                        <h5 class="mb-1">سند الأشغال</h5>
                                    </div>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label required-label">رفع السند</label>
                                    <input type="file" class="form-control" name="occupancy_receipt" accept=".pdf,.jpg,.jpeg,.png" required>
                                    <div class="form-text">PDF, JPG, PNG (الحد الأقصى 5MB)</div>
                                </div>
                            </div>
                            
                            <!-- سند إضافة مرحلة -->
                            <div class="document-item">
                                <div class="d-flex align-items-center mb-3">
                                    <div class="document-icon">
                                        <i class="fas fa-layer-group"></i>
                                    </div>
                                    <div class="flex-grow-1">
                                        <h5 class="mb-1">سند إضافة مرحلة</h5>
                                    </div>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label required-label">رفع السند</label>
                                    <input type="file" class="form-control" name="stage_addition_receipt" accept=".pdf,.jpg,.jpeg,.png" required>
                                    <div class="form-text">PDF, JPG, PNG (الحد الأقصى 5MB)</div>
                                </div>
                            </div>
                            
                            <!-- سند المساهمة المجتمعية -->
                            <div class="document-item">
                                <div class="d-flex align-items-center mb-3">
                                    <div class="document-icon">
                                        <i class="fas fa-hand-holding-usd"></i>
                                    </div>
                                    <div class="flex-grow-1">
                                        <h5 class="mb-1">سند المساهمة المجتمعية</h5>
                                        <p class="mb-0 text-muted">100 ريال على كل طالب</p>
                                    </div>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label required-label">رفع السند</label>
                                    <input type="file" class="form-control" name="community_contribution_receipt" accept=".pdf,.jpg,.jpeg,.png" required>
                                    <div class="form-text">PDF, JPG, PNG (الحد الأقصى 5MB)</div>
                                </div>
                            </div>
                            
                            <!-- سند شراء الكتب -->
                            <div class="document-item">
                                <div class="d-flex align-items-center mb-3">
                                    <div class="document-icon">
                                        <i class="fas fa-book"></i>
                                    </div>
                                    <div class="flex-grow-1">
                                        <h5 class="mb-1">سند شراء الكتب</h5>
                                    </div>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label required-label">رفع السند</label>
                                    <input type="file" class="form-control" name="book_purchase_receipt" accept=".pdf,.jpg,.jpeg,.png" required>
                                    <div class="form-text">PDF, JPG, PNG (الحد الأقصى 5MB)</div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- المستندات الإضافية -->
                    <div class="step-card mb-4">
                        <div class="step-header">
                            <i class="fas fa-file-medical"></i>
                            <span>مستندات إضافية</span>
                        </div>
                        <div class="step-body">
                            <!-- صورة عقد الإيجار -->
                            <div class="document-item">
                                <div class="d-flex align-items-center mb-3">
                                    <div class="document-icon">
                                        <i class="fas fa-file-contract"></i>
                                    </div>
                                    <div class="flex-grow-1">
                                        <h5 class="mb-1">صورة عقد الإيجار الأصلي</h5>
                                        <p class="mb-0 text-muted">يجب أن يكون العقد ساري المفعول</p>
                                    </div>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label required-label">رفع صورة العقد</label>
                                    <input type="file" class="form-control" name="rental_contract_image" accept=".pdf,.jpg,.jpeg,.png" required>
                                    <div class="form-text">PDF, JPG, PNG (الحد الأقصى 5MB)</div>
                                </div>
                            </div>
                            
                            <!-- سند الدفاع المدني -->
                            <div class="document-item">
                                <div class="d-flex align-items-center mb-3">
                                    <div class="document-icon">
                                        <i class="fas fa-fire-extinguisher"></i>
                                    </div>
                                    <div class="flex-grow-1">
                                        <h5 class="mb-1">سند الدفاع المدني</h5>
                                    </div>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label required-label">رفع السند</label>
                                    <input type="file" class="form-control" name="civil_defense_receipt" accept=".pdf,.jpg,.jpeg,.png" required>
                                    <div class="form-text">PDF, JPG, PNG (الحد الأقصى 5MB)</div>
                                </div>
                            </div>
                            
                            <!-- المخالفات -->
                            <div class="document-item">
                                <div class="d-flex align-items-center mb-3">
                                    <div class="document-icon">
                                        <i class="fas fa-exclamation-triangle text-warning"></i>
                                    </div>
                                    <div class="flex-grow-1">
                                        <h5 class="mb-1">المخالفات (غرامات تأخير)</h5>
                                    </div>
                                </div>
                                <div class="mb-3">
                                    <div class="form-check form-switch">
                                       <input class="form-check-input" type="checkbox" id="has_violations" name="has_violations" value="1">
                                       <label class="form-check-label" for="has_violations">هل هناك مخالفات (غرامات تأخير)؟</label>
                                    </div>
                                    <div id="violations_upload"  class="mt-3 d-none">
                                        <label class="form-label">رفع ملف المخالفات</label>
                                        <input type="file" class="form-control" name="violations" accept=".pdf,.jpg,.jpeg,.png">
                                        <div class="form-text">PDF, JPG, PNG (الحد الأقصى 5MB)</div>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- تجاوز الطاقة الاستيعابية -->
                            <div class="document-item">
                                <div class="d-flex align-items-center mb-3">
                                    <div class="document-icon">
                                        <i class="fas fa-users text-info"></i>
                                    </div>
                                    <div class="flex-grow-1">
                                        <h5 class="mb-1">تجاوز الطاقة الاستيعابية</h5>
                                    </div>
                                </div>
                                <div class="mb-3">
                                    <div class="form-check form-switch">
                                      <input class="form-check-input" type="checkbox" id="has_capacity_issue" name="has_capacity_issue" value="1">
                                        <label class="form-check-label" for="has_capacity_issue">هل تم تجاوز الطاقة الاستيعابية؟</label>
                                    </div>
                                    <div id="capacity_upload"  class="mt-3 d-none">
                                        <label class="form-label">رفع ملف الطاقة الاستيعابية</label>
                                        <input type="file" class="form-control" name="capacity" accept=".pdf,.jpg,.jpeg,.png">
                                        <div class="form-text">PDF, JPG, PNG (الحد الأقصى 5MB)</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    















<!-- 


<div class="document-item">
                                <div class="d-flex align-items-center mb-3">
                                    <div class="document-icon">
                                        <i class="fas fa-chalkboard-teacher"></i>
                                    </div>
                                    <div class="flex-grow-1">
                                        <h5 class="mb-1">وثائق المعلمين</h5>
                                        <p class="mb-0 text-muted">يجب أن تشمل: الشهادات العلمية، عقد العمل،  </p>
                                    </div>
                                      <a href="{{ route('download.teacher.report') }}"     class="btn btn-outline-primary mt-3">
                           <i class="fas fa-file-word me-2"></i> تحميل كشف المعلمين
    -->
                    <!-- الإحصائيات -->
                    <div class="step-card mb-4">
                        <div class="step-header">
                            <i class="fas fa-chart-bar"></i>
                            <span>الإحصائيات</span>
                        </div>
                        <div class="step-body">
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <div class="stat-item">
                                        <div class="stat-header">
                                            <h5>عدد الطلاب</h5>
                                            <a href="{{ route('download.student.report') }}" 
                    class="btn btn-outline-primary mt-3">
                           <i class="fas fa-file-word me-2"></i> تحميل  النموذج
</a>

                                        </div>
                                        <input type="file" class="form-control" name="students_count" required>
                                    </div>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <div class="stat-item">
                                        <div class="stat-header">
                                            <h5>بيانات متعلقة باحتياجات المدرسة </h5>
                                            <a href="{{ route('student.report') }}" 
                                          class="btn btn-outline-primary mt-3">
                                               <i class="fas fa-file-word me-2"></i> تحميل  النموذج
                                                       </a>

                                        </div>
                                        <input type="file" class="form-control" name="classes_count" required>
                                    </div>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <div class="stat-item">
                                        <div class="stat-header">
                                            <h5>عدد المعلمين</h5>
                                                <a href="{{ route('download.teacher.report') }}" 
                                          class="btn btn-outline-primary mt-3">
                                               <i class="fas fa-file-word me-2"></i> تحميل  النموذج
                                                       </a>
                                        </div>
                                        <input type="file" class="form-control" name="teachers_count" required>
                                    </div>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <div class="stat-item">
                                        <div class="stat-header">
                                            <h5>نسبة النجاح والرسوب </h5>
                                            <a href="{{ route('download.teacher.report') }}" 
                                          class="btn btn-outline-primary mt-3">
                                               <i class="fas fa-file-word me-2"></i> تحميل  النموذج
                                                       </a>
                                        </div>
                                        <input type="file" class="form-control" name="pass_count" required>
                                    </div>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <div class="stat-item">
                                        <div class="stat-header">
                                            <h5>نسبة الغياب </h5>
                                                <a href="{{ route('download.teacher.report') }}" 
                                          class="btn btn-outline-primary mt-3">
                                               <i class="fas fa-file-word me-2"></i> تحميل  النموذج
                                                       </a>
                                        </div>
                                        <input type="file" class="form-control" name="fail_count" required>
                                    </div>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <div class="stat-item">
                                        <div class="stat-header">
                                            <h5>عدد المناهج</h5>
                                                <a href="{{ route('download.teacher.report') }}" 
                                          class="btn btn-outline-primary mt-3">
                                               <i class="fas fa-file-word me-2"></i> تحميل  النموذج
                                                       </a>
                                        </div>
                                        <input type="file" class="form-control" name="curriculums_count" required>
                                    </div>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <div class="stat-item">
                                        <div class="stat-header">
                                            <h5>  التعهدات</h5>
                                                 <a href="{{ route('school') }}" 
                                          class="btn btn-outline-primary mt-3">
                                               <i class="fas fa-file-word me-2"></i> تحميل  النموذج
                                                       </a>
                                        </div>
                                        <input type="file" class="form-control" name="class_hours" required>
                                    </div>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <div class="stat-item">
                                        <div class="stat-header">
                                            <h5> القوى العاملة</h5>
                                                <a href="{{ route('download.teacher.report') }}" 
                                          class="btn btn-outline-primary mt-3">
                                               <i class="fas fa-file-word me-2"></i> تحميل  النموذج
                                                       </a>
                                        </div>
                                        <input type="file" class="form-control" name="workforce_count" required>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- الملفات الإضافية للإحصائيات -->
                         
                            
                         
                          
                            
                         
                        </div>
                    </div>
                    
                    <!-- الموافقة -->
                    <div class="mb-4">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" name="agreement" id="agreement" required>
                            <label class="form-check-label" for="agreement">
                                أوافق على أن جميع المعلومات المقدمة صحيحة، وأتحمل المسؤولية القانونية في حال مخالفة ذلك.
                            </label>
                        </div>
                    </div>
                    
                    <!-- أزرار التنقل -->
                    <div class="d-flex justify-content-between">
                        <button type="reset" class="btn btn-secondary">
                            <i class="fas fa-eraser me-2"></i>مسح النموذج
                        </button>
                        <button type="submit" class="btn btn-primary">
                            تقديم الطلب <i class="fas fa-paper-plane ms-2"></i>
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    
    <footer class="footer">
        <div class="container">
            <div class="row">
                <div class="col-md-6">
                    <p>وزارة التربية والتعليم - الجمهورية اليمنية</p>
                </div>
                <div class="col-md-6 text-md-end">
                    <div class="footer-links">
                        <a href="#" class="text-white me-3">الشروط والأحكام</a>
                        <a href="#" class="text-white me-3">سياسة الخصوصية</a>
                        <a href="#" class="text-white me-3">الدعم الفني</a>
                        <a href="#" class="text-white">تواصل معنا</a>
                    </div>
                </div>
            </div>
        </div>
    </footer>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // تفعيل أقسام المخالفات والطاقة الاستيعابية
        document.getElementById('has_violations').addEventListener('change', function() {
            document.getElementById('violations_upload').classList.toggle('d-none', !this.checked);
        });
        
        document.getElementById('has_capacity_issue').addEventListener('change', function() {
            document.getElementById('capacity_upload').classList.toggle('d-none', !this.checked);
        });
    </script>
</body>
</html>

