<div class="container mt-4">
    <div class="row justify-content-center">
        <div class="col-lg-10">
            <div class="card shadow-lg border-0 rounded-4">
                <div class="card-header bg-primary text-white text-center rounded-top-4">
                    <h3 class="mb-0">تسجيل مستخدم جديد</h3>
                </div>

                <div class="card-body p-4">
                    @if($errors->any())
                        <div class="alert alert-danger">
                            <ul class="mb-0">
                                @foreach($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                    <form action="{{ route('users.store') }}" method="POST" enctype="multipart/form-data">
                        @csrf

                        <div class="row g-4">

                            <!-- الاسم الكامل -->
                            <div class="col-md-6">
                                <label for="name" class="form-label fw-bold">الاسم الكامل</label>
                                <input type="text" class="form-control rounded-pill @error('name') is-invalid @enderror" 
                                       name="name" value="{{ old('name') }}" required>
                                @error('name')
                                    <div class="invalid-feedback">
                                        {{ $message }}
                                    </div>
                                @enderror
                            </div>

                            <!-- البريد الإلكتروني -->
                            <div class="col-md-6">
                                <label for="email" class="form-label fw-bold">البريد الإلكتروني</label>
                                <input type="email" class="form-control rounded-pill @error('email') is-invalid @enderror" 
                                       name="email" value="{{ old('email') }}" required>
                                @error('email')
                                    <div class="invalid-feedback">
                                        {{ $message }}
                                    </div>
                                @enderror
                            </div>

                            <!-- رقم الهاتف -->
                            <div class="col-md-6">
                                <label for="phone" class="form-label fw-bold">رقم الهاتف</label>
                                <input type="text" class="form-control rounded-pill @error('phone') is-invalid @enderror" 
                                       name="phone" value="{{ old('phone') }}" required>
                                @error('phone')
                                    <div class="invalid-feedback">
                                        {{ $message }}
                                    </div>
                                @enderror
                            </div>

                            <!-- الجنس -->
                            <div class="col-md-6">
                                <label for="gender" class="form-label fw-bold">الجنس</label>
                                <select name="gender" class="form-select rounded-pill @error('gender') is-invalid @enderror" required>
                                    <option value="">اختر الجنس</option>
                                    <option value="male" {{ old('gender') == 'male' ? 'selected' : '' }}>ذكر</option>
                                    <option value="femal" {{ old('gender') == 'femal' ? 'selected' : '' }}>أنثى</option> <!-- تم التعديل هنا إلى femal -->
                                </select>
                                @error('gender')
                                    <div class="invalid-feedback">
                                        {{ $message }}
                                    </div>
                                @enderror
                            </div>

                            <!-- المحافظة -->
                            <div class="col-md-6">
                                <label for="city_id" class="form-label fw-bold">المحافظة</label>
                                <select name="city_id" class="form-select rounded-pill @error('city_id') is-invalid @enderror" required>
                                    <option value="">اختر المحافظة</option>
                                    @foreach($cities as $city)
                                        <option value="{{ $city->id }}" {{ old('city_id') == $city->id ? 'selected' : '' }}>
                                            {{ $city->name }}
                                        </option>
                                    @endforeach
                                </select>
                                @error('city_id')
                                    <div class="invalid-feedback">
                                        {{ $message }}
                                    </div>
                                @enderror
                            </div>

                            <!-- الصورة -->
                            <div class="col-md-6">
                                <label for="image" class="form-label fw-bold">الصورة الشخصية</label>
                                <input type="file" class="form-control rounded-pill @error('image') is-invalid @enderror" 
                                       name="image" accept="image/*">
                                @error('image')
                                    <div class="invalid-feedback">
                                        {{ $message }}
                                    </div>
                                @enderror
                            </div>

                            <!-- كلمة المرور -->
                            <div class="col-md-6">
                                <label for="password" class="form-label fw-bold">كلمة المرور</label>
                                <input type="password" class="form-control rounded-pill @error('password') is-invalid @enderror" 
                                       name="password" required>
                                @error('password')
                                    <div class="invalid-feedback">
                                        {{ $message }}
                                    </div>
                                @enderror
                            </div>

                            <!-- تأكيد كلمة المرور -->
                            <div class="col-md-6">
                                <label for="password_confirmation" class="form-label fw-bold">تأكيد كلمة المرور</label>
                                <input type="password" class="form-control rounded-pill" 
                                       name="password_confirmation" required>
                            </div>

                        </div>

                        <div class="text-center mt-4">
                            <button type="submit" class="btn btn-success px-5 py-2 rounded-pill">
                                <i class="fas fa-user-plus me-2"></i> إنشاء المستخدم
                            </button><br>
                            
                            <a href="{{ route('login') }}">العودة إالى الصفحة السابقه</a>
                            
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Bootstrap CSS -->
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.rtl.min.css" rel="stylesheet">

<!-- Font Awesome (لأيقونات الزر) -->
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">

<!-- تخصيص إضافي -->
<style>
    body {
        background-color: #f8f9fa;
    }
    .form-label {
        font-weight: 600;
    }
    .card {
        border-radius: 1rem;
    }
    .invalid-feedback {
        display: block;
        margin-top: 5px;
    }
</style>
<!-- Bootstrap Bundle -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>


