@extends('client.layout')
 
@section('title', 'طلب ترخيص - بيانات الفرع')
 
@section('content')
<div class="container mt-5" dir="rtl">
    <h3 class="mb-4 text-center text-primary">الخطوة الثانية - بيانات الفرع</h3>

    @if (session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif

    <form action="{{ route('client.license.step2.store', $school->id) }}" method="POST" enctype="multipart/form-data">
        @csrf
        <input type="hidden" name="school_id" value="{{ $school->id }}">

        <div class="row mb-3">
            <div class="col-md-6">
                <label>اسم المدرسة</label>
                <input type="text" class="form-control" value="{{ $school->school_name }}" disabled>
            </div>
            <div class="col-md-6">
                <label>اسم الفرع</label>
                <input type="text" name="name" class="form-control" required>
            </div>
        </div>

        <div class="row mb-3">
            <div class="col-md-6">
                <label>المنطقة</label>
                <select name="area_id" class="form-control" required>
                    <option value=""> اختر المنطقة </option>
                    @foreach($areas as $area)
                        <option value="{{ $area->id }}">{{ $area->name }}</option>
                    @endforeach
                </select>
            </div>
            <div class="col-md-6">
                <label>عنوان المدرسة</label>
                <input type="text" name="school_address" class="form-control" required>
            </div>
        </div>

        <div class="row mb-3">
            <div class="col-md-6">
                <label>أقرب معلم بارز</label>
                <input type="text" name="nearest_landmark" class="form-control">
            </div>
        </div>

        <!-- خريطة جوجل -->
        <div class="row mb-3">
            <div class="col-12">
                <div class="alert alert-info">
                    <i class="bi bi-info-circle"></i> 
                    يرجى النقر على الموقع الدقيق للمدرسة في الخريطة
                </div>
                <div id="map" style="height: 400px; width: 100%; border: 1px solid #ddd; border-radius: 5px;"></div>
            </div>
        </div>

        <!-- حقول الإحداثيات المخفية -->
        <input type="hidden" name="latitude" id="latitude">
        <input type="hidden" name="longitude" id="longitude">

        <hr>

        <h5 class="text-info">معلومات المدير</h5>
        <div class="row mb-3">
            <div class="col-md-4">
                <label>اسم المدير</label>
                <input type="text" name="name_manage" class="form-control">
            </div>
            <div class="col-md-4">
                <label>رقم الهاتف</label>
                <input type="text" name="phone_manage" class="form-control">
            </div>
            <div class="col-md-4">
                <label>السيرة الذاتية (PDF)</label>
                <div class="input-group">
                    <input type="file" name="cv_manage" class="form-control" accept="application/pdf">
                    <span class="input-group-text bg-light"><i class="bi bi-file-earmark-pdf text-danger"></i></span>
                </div>
            </div>
        </div>

        <hr>

        <h5 class="text-info">معلومات إضافية</h5>
        <div class="row mb-3">
            <div class="col-md-6">
                <label>رقم هاتف المدرسة</label>
                <input type="text" name="phone" class="form-control">
            </div>
            <div class="col-md-6">
                <label>وصف الفرع</label>
                <textarea name="description" class="form-control" rows="2"></textarea>
            </div>
        </div>

        <hr>

        <h5 class="text-info">المرفقات</h5>
        <div class="row g-3">
            @php
                $attachments = [
                    'contrect_image' => 'صورة عقد الإيجار',
                    'plan_image' => 'صورة المخطط',
                    'main_image' => 'صورة المبنى الرئيسي',
                    'secondary_image' => 'صورة المبنى الثانوي',
                    'file_feasibility' => 'دراسة الجدوى (PDF)',
                    'bank_statement' => 'كشف الحساب البنكي (PDF)',
                    'other_document' => ' خطة توزيع الحصص الدراسية الأسبوعية '
                ];
            @endphp

            @foreach($attachments as $field => $label)
                <div class="col-md-4">
                    <label>{{ $label }}</label>
                    <div class="input-group">
                        <input type="file" name="{{ $field }}" class="form-control">
                        <span class="input-group-text bg-light">
                            @if(Str::contains($field, ['image', 'main', 'secondary', 'contrect', 'plan']))
                                <i class="bi bi-image text-success"></i>
                            @else
                                <i class="bi bi-file-earmark-pdf text-danger"></i>
                            @endif
                        </span>
                    </div>
                </div>
            @endforeach
        </div>

        <div class="mt-4 text-center">
            <button type="submit" class="btn btn-primary px-5">التالي</button>
        </div>
    </form>
</div>

<!-- Bootstrap CSS -->
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.rtl.min.css" rel="stylesheet">

<!-- Bootstrap Icons -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css">

<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

<!-- Google Maps API -->
<script>
    function initMap() {
        // الإحداثيات الافتراضية (صنعاء)
        const defaultLocation = { lat: 15.3694, lng: 44.1910 };
        const map = new google.maps.Map(document.getElementById("map"), {
            zoom: 14,
            center: defaultLocation,
            gestureHandling: "greedy",
            mapTypeControl: true,
            streetViewControl: false,
            fullscreenControl: true,
            mapTypeId: "hybrid",
            styles: [
                {
                    featureType: "poi",
                    stylers: [{ visibility: "off" }]
                }
            ]
        });

        // إنشاء علامة قابلة للسحب
        const marker = new google.maps.Marker({
            position: defaultLocation,
            map: map,
            draggable: true,
            title: "موقع المدرسة"
        });

        // تحديث الإحداثيات عند النقر على الخريطة
        map.addListener("click", (event) => {
            marker.setPosition(event.latLng);
            updateCoordinates(event.latLng);
        });

        // تحديث الإحداثيات عند سحب العلامة
        marker.addListener("dragend", (event) => {
            updateCoordinates(event.latLng);
        });

        // تحديث حقلي الإحداثيات المخفية
        function updateCoordinates(location) {
            document.getElementById("latitude").value = location.lat();
            document.getElementById("longitude").value = location.lng();
            
            // إظهار إشعار للمستخدم
            document.querySelector(".alert-info").innerHTML = 
                `<i class="bi bi-check-circle text-success"></i> تم تحديد الموقع بنجاح: 
                 ${location.lat().toFixed(6)}, ${location.lng().toFixed(6)}`;
        }
    }
</script>
<script async defer 
    src="https://maps.googleapis.com/maps/api/js?key=AIzaSyBpgVKnqL33ZzJDM4r3ejHsJGdzp3jnXmU&callback=initMap&language=ar&region=YE">
</script>
@endsection
