@extends('client.layout')

@section('title', 'نتيجة تتبع الطلب')

@section('content')
<div class="container mt-5">
    <div class="card border-0 shadow">
        <div class="card-header bg-primary text-white py-3">
            <h3 class="mb-0 text-center">نتيجة تتبع طلب الترخيص</h3>
        </div>
        
        <div class="card-body">
            @if(session('success'))
                <div class="alert alert-success text-center">{{ session('success') }}</div>
            @elseif(session('error'))
                <div class="alert alert-danger text-center">{{ session('error') }}</div>
            @elseif(session('info'))
                <div class="alert alert-info text-center">{{ session('info') }}</div>
            @endif

            <div class="table-responsive">
                <table class="table table-bordered table-striped">
                    <tbody>
                        <tr>
                            <th class="bg-light" width="30%">اسم المدرسة</th>
                            <td>{{ $school->school_name }}</td>
                        </tr>
                        <tr>
                            <th class="bg-light">اسم الفرع</th>
                            <td>{{ $branch->name }}</td>
                        </tr>
                        <tr>
                            <th class="bg-light">الحالة</th>
                            <td>
                                @if($license->status == 'مقبول')
                                    <span class="badge bg-success p-2 fs-6">مقبول</span>
                                @elseif($license->status == 'مرفوض')
                                    <span class="badge bg-danger p-2 fs-6">مرفوض</span>
                                @else
                                    <span class="badge bg-warning text-dark p-2 fs-6">قيد المراجعة</span>
                                @endif
                            </td>
                        </tr>
                        <tr>
                            <th class="bg-light">الملاحظات</th>
                            <td>{{ $license->notes ?? 'لا توجد ملاحظات' }}</td>
                        </tr>

                        @if($license->status === 'مقبول' && $license->approval_file)
                        <tr>
                            <th class="bg-light">ملف الموافقة</th>
                            <td>
                                <div class="d-flex align-items-center">
                                    <a href="{{ asset('storage/approval_files/' . $license->approval_file) }}" 
                                       class="btn btn-success d-flex align-items-center me-3"
                                       target="_blank">
                                       <i class="fas fa-file-pdf me-2"></i> عرض الملف
                                    </a>
                                    
                                    <a href="{{ asset('storage/approval_files/' . $license->approval_file) }}" 
                                       class="btn btn-outline-primary d-flex align-items-center"
                                       download>
                                       <i class="fas fa-download me-2"></i> تحميل الملف
                                    </a>
                                </div>
                                
                                <!-- رابط مباشر للملف -->
                                <div class="mt-2">
                                    <small class="text-muted">
                                        <i class="fas fa-link me-1"></i> 
                                        <a href="{{ asset('storage/approval_files/' . $license->approval_file) }}" target="_blank">
                                            رابط الملف المباشر
                                        </a>
                                    </small>
                                </div>
                            </td>
                        </tr>
                        @endif
                    </tbody>
                </table>
            </div>
            
            <div class="text-center mt-4">
                <a href="{{ route('client.dashboard') }}" class="btn btn-primary px-4 py-2">
                    <i class="fas fa-arrow-left me-2"></i> العودة للصفحة الرئيسية
                </a>
            </div>
        </div>
    </div>
</div>

@push('styles')
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
<style>
    .card {
        border-radius: 10px;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
    }
    .card-header {
        border-top-left-radius: 10px !important;
        border-top-right-radius: 10px !important;
    }
    th.bg-light {
        background-color: #f8f9fa !important;
        font-weight: 600;
    }
    .badge {
        font-size: 1rem;
        padding: 0.5em 0.8em;
        border-radius: 4px;
    }
    .table-striped tbody tr:nth-of-type(odd) {
        background-color: rgba(0, 0, 0, 0.02);
    }
</style>
@endpush

@endsection











<!-- @extends('client.welcome')

@section('title', 'نتيجة تتبع الطلب')

@section('content')
<div class="container mt-5">
    <h3 class="mb-4 text-center">نتيجة تتبع طلب الترخيص</h3>

    @if(session('success'))
        <div class="alert alert-success text-center">{{ session('success') }}</div>
    @elseif(session('error'))
        <div class="alert alert-danger text-center">{{ session('error') }}</div>
    @elseif(session('info'))
        <div class="alert alert-info text-center">{{ session('info') }}</div>
    @endif

    <table class="table table-bordered table-striped mt-4">
        <tr>
            <th>اسم المدرسة</th>
            <td>{{ $school->school_name }}</td>
        </tr>
        <tr>
            <th>اسم الفرع</th>
            <td>{{ $branch->name }}</td>
        </tr>
        <tr>
            <th>الحالة</th>
            <td>
                @if($license->status == 'مقبول')
                    <span class="badge bg-success">مقبول</span>
                @elseif($license->status == 'مرفوض')
                    <span class="badge bg-danger">مرفوض</span>
                @else
                    <span class="badge bg-warning text-dark">قيد المراجعة</span>
                @endif
            </td>
        </tr>
        <tr>
            <th>الملاحظات</th>
            <td>{{ $license->notes ?? 'لا توجد ملاحظات' }}</td>
        </tr>

        @if($license->status === 'مقبول' && $license->approval_file)
        <tr>
            <th>ملف الموافقة</th>
            <td>
                <a href="{{ asset('uploads/approvals/' . $license->approval_file) }}" target="_blank" class="btn btn-primary">
                    عرض ملف الموافقة PDF
                </a>
            </td>
        </tr>
        @endif
    </table>

 
</div>
@endsection -->
