<table class="table table-bordered table-striped table-hover align-middle text-center bg-white shadow-sm">
    <thead class="table-primary">
        <tr>
            <th>الرقم</th>
            <th>الاسم</th>
            <th>البريد</th>
            <th>الهاتف</th>
            <th>الجنس</th>
            <th>المحافظة</th>
            <th>الصورة</th>
            <th>العمليات</th>
        </tr>
    </thead>
    <tbody>
        @foreach($users as $user)
            <tr>
                <td>{{ $user->id }}</td>
                <td>{{ $user->name }}</td>
                <td>{{ $user->email }}</td>
                <td>{{ $user->phone }}</td>
                <td>{{ $user->gender }}</td>
                <td>{{ $user->city->name ?? 'غير محدد' }}</td>
                <td>
                    @if($user->image && file_exists(public_path('uploads/users/' . $user->image)))
                        <img src="{{ asset('uploads/users/' . $user->image) }}" width="50" height="50" class="rounded-circle border">
                    @else
                        <span class="text-muted">لا توجد</span>
                    @endif
                </td>
                <td>
                    <a href="{{ url('/users/' . $user->id . '/edit') }}" class="btn btn-sm btn-warning">
                        <i class="bi bi-pencil-square"></i> تعديل
                    </a>
                    <a href="{{ route('users.assignRoleForm', $user->id) }}" class="btn btn-sm btn-info">
                        <i class="bi bi-shield-lock"></i> تعيين دور
                    </a>
                    <form action="{{ url('/users/' . $user->id) }}" method="POST" class="d-inline" onsubmit="return confirm('هل أنت متأكد من الحذف؟')">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="btn btn-sm btn-danger">
                            <i class="bi bi-trash"></i> حذف
                        </button>
                    </form>
                </td>
            </tr>
        @endforeach
    </tbody>
</table>
