@extends('admin.layout.master')

@section('content')

<div class="card p-4">

    <div class="d-flex justify-content-between align-items-center mb-3">
        <h2 class="mb-0">قائمة المدارس</h2>
        <a href="{{ route('schools.create') }}" class="btn btn-success">إضافة مدرسة جديدة</a>
    </div>

    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif

    <table class="table table-bordered table-striped text-center">
        <thead class="table-light">
            <tr>
                <th>#</th>
                <th>اسم المدرسة</th>
                <th>الأنواع</th>
                <th>المحافظة</th>
                <th>الشعار</th>
                <th>المستخدم</th>
                <th>الإجراءات</th>
            </tr>
        </thead>
        <tbody>
            @forelse ($schools as $index => $school)
                <tr>
                    <td>{{ $index + 1 }}</td>
                    <td>{{ $school->school_name }}</td>
                    <td>
                        @php
                            $types = json_decode($school->type, true) ?? [];
                        @endphp

                        @foreach ($types as $type)
                            <span class="badge bg-info text-dark">
                               @if($type === 'pteparatory') تمهيدي
                                @elseif($type === 'primary') أساسي
                                @elseif($type === 'middle') إعدادي
                                @elseif($type === 'high') ثانوي
                                @else {{ $type }}
                                @endif
                            </span>
                        @endforeach
                    </td>
                    <td>{{ $school->city->name ?? 'غير محددة' }}</td>
                    <td>
                        @if($school->logo)
                            <img src="{{ asset('storage/' . $school->logo) }}" alt="الشعار" width="60" height="60">
                        @else
                            <span class="text-muted">لا يوجد</span>
                        @endif
                    </td>
                    <td>{{ $school->user->name ?? 'غير محدد' }}</td>
                    <td>
                        <a href="{{ route('schools.edit', $school->id) }}" class="btn btn-sm btn-warning">تعديل</a>

                        <form action="{{ route('schools.destroy', $school->id) }}" method="POST" style="display:inline-block;">
                            @csrf
                            @method('DELETE')
                            <button class="btn btn-sm btn-danger" onclick="return confirm('هل أنت متأكد من الحذف؟')">حذف</button>
                        </form>
                    </td>
                </tr>
            @empty
                <tr>
                    <td colspan="7" class="text-muted">لا توجد مدارس حتى الآن</td>
                </tr>
            @endforelse
        </tbody>
    </table>
</div>

@endsection
