@extends('admin.layout.master')

@section('content')
<div class="container mt-4">
    <h4 class="mb-4"><i class="bi bi-people"></i> جميع المستخدمين</h4>

    <!-- نموذج البحث -->
    <form action="{{ route('users.index') }}" method="GET" class="mb-3 d-flex" style="max-width: 400px;">
        <div class="input-group">
            <input 
                type="text" 
                name="email" 
                class="form-control" 
                placeholder="البحث بالبريد الإلكتروني..." 
                value="{{ request('email') }}"
            >
            <button class="btn btn-primary" type="submit">
                <i class="bi bi-search"></i> بحث
            </button>
            @if(request()->has('email'))
                <a href="{{ route('users.index') }}" class="btn btn-secondary">
                    <i class="bi bi-arrow-counterclockwise"></i> إعادة تعيين
                </a>
            @endif
        </div>
    </form>

    <!-- رسائل الحالة -->
    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif

    @if(request()->has('email') && $users->isEmpty())
        <div class="alert alert-warning">
            لا يوجد مستخدم بهذا البريد الإلكتروني: "{{ request('email') }}"
        </div>
    @endif

    <!-- جدول المستخدمين -->
    <table class="table table-bordered table-striped text-center">
        <thead class="table-primary">
            <tr>
                <th>الرقم</th>
                <th>الاسم</th>
                <th>البريد</th>
                <th>الهاتف</th>
                <th>النوع</th>
                <th>المدينة</th>
                <th>الإجراء</th>
            </tr>
        </thead>
        <tbody>
            @forelse($users as $user)
            <tr>
                <td>{{ $user->id }}</td>
                <td>{{ $user->name }}</td>
                <td>{{ $user->email }}</td>
                <td>{{ $user->phone ?? '-' }}</td>
                <td>{{ $user->gender === 'male' ? 'ذكر' : 'أنثى' }}</td>
                <td>{{ $user->city->name ?? '-' }}</td>
                <td>
                    <a href="{{ route('users.edit', $user->id) }}" class="btn btn-sm btn-warning">
                        <i class="bi bi-pencil-square"></i> تعديل
                    </a>
                    <form action="{{ route('users.destroy', $user->id) }}" method="POST" class="d-inline" onsubmit="return confirm('هل أنت متأكد من الحذف؟')">
                        @csrf
                        @method('DELETE')
                        <button class="btn btn-sm btn-danger">
                            <i class="bi bi-trash"></i> حذف
                        </button>
                    </form>
                </td>
            </tr>
            @empty
            <tr>
                <td colspan="7" class="text-muted">لا توجد بيانات</td>
            </tr>
            @endforelse
        </tbody>
    </table>

    <!-- روابط الصفحات -->
    <div class="d-flex justify-content-center">
        {!! $users->withQueryString()->links() !!}
    </div>
</div>
@endsection
<script>
    document.querySelector('input[name="email"]').addEventListener('input', function() {
        const search = this.value;
        const url = '{{ route("users.liveSearch") }}';

        fetch(url + '?search=' + encodeURIComponent(search))
            .then(res => res.text())
            .then(data => {
                document.querySelector('#search-results').innerHTML = data;
            });
    });
</script>

<div id="search-results"></div>
