@extends('admin.layout.master')

@section('content')
<div class="card p-4">
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h4>قائمة التراخيص</h4>
        <a href="{{ route('licenses.create') }}" class="btn btn-success">إضافة ترخيص جديد</a>
    </div>

    <table class="table table-bordered table-striped">
        <thead class="table-light">
            <tr>
                <th>الرقم</th>
                <th>اسم الفرع</th>
                <th>الحالة</th>
                <th>المستخدم الحالي</th>
                <th>المستخدم التالي</th>
                <th>الملاحظة</th>
                <th>الحالة النهائية</th>
                <th>إجراءات</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($licenses as $license)
                <tr>
                    <td>{{ $license->id }}</td>
                    <td>{{ $license->branch->name ?? 'غير متوفر' }}</td>
                    <td>
                        @switch($license->status)
                            @case('under_review')
                                <span class="badge bg-warning text-dark">قيد المراجعة</span>
                                @break
                            @case('approved')
                                <span class="badge bg-success">مقبول</span>
                                @break
                            @case('rejected')
                                <span class="badge bg-danger">مرفوض</span>
                                @break
                        @endswitch
                    </td>
                    <td>{{ $license->currentUser->name ?? 'غير متوفر' }}</td>
                    <td>{{ $license->nextUser->name ?? 'غير متوفر' }}</td>
                    <td>{{ $license->note }}</td>
                    <td>{{ $license->final_status }}</td>
                    <td>
                        <a href="{{ route('licenses.edit', $license->id) }}" class="btn btn-sm btn-warning">تعديل</a>
                        <form action="{{ route('licenses.destroy', $license->id) }}" method="POST" style="display:inline-block;">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('هل تريد حذف هذا الترخيص؟')">حذف</button>
                        </form>
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
</div>
@endsection
