@extends('admin.layout.master')

@section('content')
<div class="card p-4">
    <h4 class="mb-4">إضافة ترخيص جديد</h4>

    @if ($errors->any())
        <div class="alert alert-danger">
            <ul class="mb-0">
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <form method="POST" action="{{ route('licenses.store') }}">
        @csrf

        <div class="row">
            <div class="col-md-6 mb-3">
                <label for="branch_name" class="form-label">اسم الفرع</label>
                <select name="branche_id" id="branche_id" class="form-select" required>
    <option value="">الفرع</option>
    @foreach ($branches as $branch)
        <option value="{{ $branch->id }}">{{ $branch->name }}</option>
    @endforeach
</select>

            </div>

            <div class="col-md-6 mb-3">
                <label for="status" class="form-label">الحالة</label>
                <select name="status" id="status" class="form-select" required>
                    <option value="under_review">قيد المراجعة</option>
                    <option value="approved">مقبول</option>
                    <option value="rejected">مرفوض</option>
                </select>
            </div>

       <div class="col-md-6">
    <label class="form-label">المستخدم الحالي</label>
    <input type="text" class="form-control" value="{{ auth()->user()->name }}" disabled>
    <input type="hidden" name="current_user_id" value="{{ auth()->user()->id }}">
</div>


            <div class="col-md-6 mb-3">
                <label for="next_user_id" class="form-label">المستخدم التالي</label>
                <select name="next_user_id" id="next_user_id" class="form-select" required>
                    @foreach ($users as $user)
                        <option value="{{ $user->id }}">{{ $user->name }}</option>
                    @endforeach
                </select>
            </div>

            <div class="col-md-6 mb-3">
                <label for="note" class="form-label">الملاحظة</label>
                <input type="text" name="note" id="note" class="form-control" required>
            </div>

            <div class="col-md-6 mb-3">
                <label for="final_status" class="form-label">الحالة النهائية</label>
                <input type="text" name="final_status" id="final_status" class="form-control" required>
            </div>
        </div>

        <button type="submit" class="btn btn-primary">حفظ الترخيص</button>
    </form>
</div>
@endsection
