

@extends('admin.layout.master')

@section('title', 'تفاصيل طلب تجديد الترخيص')

@section('content')
<div class="container py-4">
    @if(session('success'))
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        {{ session('success') }}
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
    @endif

    <div class="card border-0 shadow-lg">
        <div class="card-header bg-primary text-white py-3">
            <div class="d-flex justify-content-between align-items-center">
                <h3 class="mb-0">
                    <i class="fas fa-file-contract me-2"></i>تفاصيل طلب تجديد الترخيص {{ $renwel->id }}
                </h3>
                <span class="badge bg-light text-dark fs-5">
                    {{ $renwel->status ?? 'قيد المراجعة' }}
                </span>
            </div>
        </div>

        <div class="card-body">
            <!-- بيانات المدرسة -->
            <div class="section-header mb-4 mt-3">
                <h5 class="text-primary border-bottom border-primary pb-2 d-inline-block">
                    <i class="fas fa-school me-2"></i>بيانات المدرسة
                </h5>
            </div>
            
            <div class="row mb-4">
                <div class="col-md-4 mb-3">
                    <div class="info-item bg-light p-3 rounded border">
                        <strong class="d-block text-muted mb-1">اسم المدرسة</strong>
                        <span>{{ $renwel->school->school_name ?? '-' }}</span>
                    </div>
                </div>
                <div class="col-md-4 mb-3">
                    <div class="info-item bg-light p-3 rounded border">
                        <strong class="d-block text-muted mb-1">الفرع</strong>
                        <span>{{ $renwel->branch_name ?? '-' }}</span>
                    </div>
                </div>
                <div class="col-md-4 mb-3">
                    <div class="info-item bg-light p-3 rounded border">
                        <strong class="d-block text-muted mb-1">المديرية</strong>
                        <span>{{ $renwel->area?->name ?? '-' }}</span>
                    </div>
                </div>
                <div class="col-md-12">
                    <div class="info-item bg-light p-3 rounded border">
                        <strong class="d-block text-muted mb-1">الأقسام</strong>
                        <span>{{ implode('، ', json_decode($renwel->sections ?? '[]')) ?: '-' }}</span>
                    </div>
                </div>
            </div>

            <!-- ملفات الوثائق -->
            <div class="section-header mb-4">
                <h5 class="text-info border-bottom border-info pb-2 d-inline-block">
                    <i class="fas fa-file-alt me-2"></i>الوثائق المرفقة
                </h5>
            </div>
            
            <div class="row g-3 mb-4">
                @foreach([
                    'teachers_documents' => ' وثائق المعلمين الاشقاء والغير اشقاء',
                    'renewal_form' => 'استمارة طلب تجديد الترخيص',
                    'certificate_purchase_receipt' => 'سند شراء الشهادات',
                    'occupancy_receipt' => 'سند الأشغال',
                    'stage_addition_receipt' => 'سند إضافة مرحلة',
                    'community_contribution_receipt' => 'سند المساهمة المجتمعية',
                    'civil_defense_receipt' => 'سند الدفاع المدني',
                    'book_purchase_receipt' => 'سند شراء الكتب',
                    'rental_contract_image' => 'عقد الإيجار',
                    'violations' => 'المخالفات',
                    'capacity' => 'الطاقة الاستيعابية'
                ] as $field => $label)
                @if($renwel->$field)
                <div class="col-md-4">
                    <div class="document-item border rounded p-3 h-100">
                        <div class="d-flex justify-content-between align-items-start mb-2">
                            <strong class="text-dark">{{ $label }}</strong>
                            <a href="{{ asset('storage/' . $renwel->$field) }}" target="_blank" 
                               class="btn btn-sm btn-outline-info py-1 px-2">
                                <i class="fas fa-eye me-1"></i>عرض
                            </a>
                        </div>
                        <div class="text-truncate small text-muted">
                            <!-- {{ basename($renwel->$field) }} -->
                        </div>
                    </div>
                </div>
                @endif
                @endforeach
            </div>

            <!-- ملفات الإحصائيات -->
            <div class="section-header mb-4">
                <h5 class="text-secondary border-bottom border-secondary pb-2 d-inline-block">
                    <i class="fas fa-chart-line me-2"></i>ملفات الإحصائيات
                </h5>
            </div>
            
            <div class="row g-3 mb-4">
                @foreach([
                    'students_count' => 'عدد الطلاب',
                    'classes_count' => ' بيانات متعلقةباحتياجات المدرسة ',
                    'teachers_count' => 'عدد المعلمين',
                    'pass_count' => 'نسبة النجاح والرسوب',
                    'fail_count' => 'نسبة الغياب',
                    'curriculums_count' => 'المناهج',
                    'class_hours' => 'التعهدات',
                    'workforce_count' => 'القوى العاملة'
                ] as $field => $label)
                @if($renwel->$field)
                <div class="col-md-4">
                    <div class="document-item border rounded p-3 h-100">
                        <div class="d-flex justify-content-between align-items-start mb-2">
                            <strong class="text-dark">إحصائية {{ $label }}</strong>
                            <a href="{{ asset('storage/' . $renwel->$field) }}" target="_blank" 
                               class="btn btn-sm btn-outline-secondary py-1 px-2">
                                <i class="fas fa-eye me-1"></i>عرض
                            </a>
                        </div>
                        <div class="text-truncate small text-muted">
                            <!-- {{ basename($renwel->$field) }} -->
                        </div>
                    </div>
                </div>
                @endif
                @endforeach
            </div>

            <!-- ملف موافقة الادمن -->
            <div class="section-header mb-4">
                <h5 class="text-success border-bottom border-success pb-2 d-inline-block">
                    <i class="fas fa-check-circle me-2"></i>ملف موافقة الإدارة
                </h5>
            </div>
            
            <div class="mb-5">
                @if($renwel->admin_document)
                <div class="d-flex align-items-center bg-light-success p-3 rounded border border-success">
                    <i class="fas fa-file-pdf fs-3 text-success me-3"></i>
                    <div class="flex-grow-1">
                        <div class="fw-bold">ملف الموافقة الرسمي</div>
                        <div class="text-truncate small text-muted w-75">
                            <!-- {{ basename($renwel->admin_document) }} -->
                        </div>
                    </div>
                        <a href="{{ asset('storage/' . $renwel->admin_document) }}"  target="_blank" 
                       class="btn btn-success py-2 px-4">
                        <i class="fas fa-download me-2"></i>تحميل الموافقة
                    </a>
                </div>
                @else
                <div class="alert alert-warning bg-light-warning border-warning">
                    <i class="fas fa-exclamation-circle me-2"></i>لم يتم رفع ملف الموافقة بعد
                </div>
                @endif
            </div>

            <!-- نموذج تحديث الحالة والملاحظات -->
            <div class="section-header mb-4">
                <h5 class="text-dark border-bottom border-dark pb-2 d-inline-block">
                    <i class="fas fa-edit me-2"></i>تقييم الطلب
                </h5>
            </div>
            
            <form method="POST" action="{{ route('admin.renwels.update', $renwel->id) }}" enctype="multipart/form-data">
                @csrf
                @method('PUT')
                
                <div class="row g-4">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="notes" class="form-label fw-bold">ملاحظات المشرف:</label>
                            <textarea name="notes" id="notes" rows="4" 
                                      class="form-control border-primary @error('notes') is-invalid @enderror"
                                      placeholder="أدخل ملاحظاتك هنا...">{{ old('notes', $renwel->notes) }}</textarea>
                            @error('notes')
                            <div class="invalid-feedback d-block">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    
                    <div class="col-md-6">
                        <div class="form-group mb-4">
                            <label for="status" class="form-label fw-bold">الحالة النهائية:</label>
                            <select name="status" id="status" 
                                    class="form-select border-primary @error('status') is-invalid @enderror">
                                <!-- <option value="">-- اختر الحالة --</option> -->
                                <option value="قيد المراجعة" {{ old('status', $renwel->status) == 'قيد المراجعة' ? 'selected' : '' }}>قيد المراجعة</option>
                                <option value="مقبول" {{ old('status', $renwel->status) == 'مقبول' ? 'selected' : '' }}>مقبول</option>
                                <option value="مرفوض" {{ old('status', $renwel->status) == 'مرفوض' ? 'selected' : '' }}>مرفوض</option>
                            </select>
                            @error('status')
                            <div class="invalid-feedback d-block">{{ $message }}</div>
                            @enderror
                        </div>
                        
                        <div class="form-group">
                            <label for="approval_file" class="form-label fw-bold">رفع ملف الموافقة:</label>
                            <div class="input-group">
                                <input type="file" name="admin_document" id="admin_document" 
                                       class="form-control border-primary @error('admin_document') is-invalid @enderror" 
                                       accept=".pdf,.jpg,.jpeg,.png">
                                <button class="btn btn-outline-primary" type="button">
                                    <i class="fas fa-upload"></i>
                                </button>
                            </div>
                            <div class="form-text">صيغ الملفات المسموحة: PDF, JPG, JPEG, PNG (الحجم الأقصى: 5MB)</div>
                            @error('admin_document')
                            <div class="invalid-feedback d-block">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>
                
                <div class="d-flex justify-content-between align-items-center mt-5 pt-3 border-top">
                    <div>
                        @if($previous)
                        <a href="{{ route('admin.renwels.index', $previous->id) }}" 
                           class="btn btn-outline-primary py-2 px-4">
                            <i class="fas fa-arrow-right me-2"></i>السابق
                        </a>
                        @endif
                    </div>




                    
                    <button type="submit" class="btn btn-primary py-2 px-5">
                        <i class="fas fa-save me-2"></i>حفظ التحديثات
                    </button>
                    
               
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

<style>
    .section-header {
        position: relative;
        padding-bottom: 10px;
    }
    
    .info-item {
        transition: all 0.3s ease;
    }
    
    .info-item:hover {
        background-color: #f8f9fa !important;
        transform: translateY(-2px);
    }
    
    .document-item {
        transition: transform 0.3s ease, box-shadow 0.3s ease;
        background-color: #fafafa;
    }
    
    .document-item:hover {
        transform: translateY(-3px);
        box-shadow: 0 5px 15px rgba(0, 0, 0, 0.05);
    }
</style>
