<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="utf-8">
    <title>تسجيل دخول | البوابة الإدارية</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- الخط -->
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@400;600&display=swap" rel="stylesheet">
    <!-- Bootstrap RTL -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.rtl.min.css">
    <!-- أيقونات -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css">

    <style>
        body {
            font-family: 'Cairo', sans-serif;
            background-color: #f0f4f8;
        }
        .login-box {
            max-width: 420px;
            margin: 80px auto;
        }
        .card {
            border: none;
            box-shadow: 0 0 20px rgba(0,0,0,0.08);
            border-radius: 10px;
        }
        .login-logo img {
            height: 80px;
        }
        .login-logo {
            text-align: center;
            margin-bottom: 20px;
        }
        .login-card-body {
            padding: 30px;
        }
        .btn-primary {
            background-color: #004085;
            border-color: #004085;
        }
        .btn-primary:hover {
            background-color: #002752;
            border-color: #002752;
        }
    </style>
</head>
<body>

<div class="login-box">
    <div class="login-logo">
        <img src="{{ asset('img.jpg') }}" alt="شعار الهيئة">
        <h5 class="mt-3 text-primary">البوابة الإدارية - تسجيل الدخول</h5>
    </div>

    <div class="card">
        <div class="card-body login-card-body">

            @if(session('error'))
                <div class="alert alert-danger">{{ session('error') }}</div>
            @endif

            <form action="{{ route('admin.login') }}" method="POST">
                @csrf

                <div class="mb-3">
                    <label for="email" class="form-label">البريد الإلكتروني</label>
                    <div class="input-group">
                        <span class="input-group-text"><i class="bi bi-envelope"></i></span>
                        <input type="email" class="form-control" name="email" id="email" required>
                    </div>
                </div>

                <div class="mb-3">
                    <label for="password" class="form-label">كلمة المرور</label>
                    <div class="input-group">
                        <span class="input-group-text"><i class="bi bi-lock-fill"></i></span>
                        <input type="password" class="form-control" name="password" id="password" required>
                    </div>
                </div>

                <div class="mb-3 form-check">
                    <input type="checkbox" class="form-check-input" name="remember" id="remember">
                    <label class="form-check-label" for="remember">تذكرني</label>
                </div>

                <div class="d-grid">
                    <button type="submit" class="btn btn-primary">تسجيل الدخول</button>
                     <p>ليس لديك حساب؟ <a href="{{ route ('register') }}">إنشاء حساب جديد</a></p>
                 
                    
                </div>
            </form>

        </div>
    </div>
</div>

</body>
</html>
