@extends('admin.layout.master')

@section('content')

<div class="card p-4">
    <h2 class="mb-4">تعديل بيانات المنطقة</h2>

    <form action="{{ route('areas.update', $area->id) }}" method="POST">
        @csrf
        @method('PUT')

        <div class="mb-3">
            <label for="name" class="form-label">اسم المنطقة:</label>
            <input type="text" id="name" name="name" value="{{ $area->name }}" class="form-control" required>
        </div>

        <div class="mb-3">
            <label for="city_id" class="form-label">اختر المدينة:</label>
            <select id="city_id" name="city_id" class="form-select" required>
                @foreach($cities as $city)
                    <option value="{{ $city->id }}" {{ $area->city_id == $city->id ? 'selected' : '' }}>
                        {{ $city->name }}
                    </option>
                @endforeach
            </select>
        </div>

        <button type="submit" class="btn btn-primary">حفظ التعديلات</button>
    </form>
</div>

@endsection
