@extends('admin.layout.master')

@section('content')

<div class="card p-4">
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h2 class="mb-0">قائمة المناطق</h2>
        <a href="{{ route('areas.create') }}" class="btn btn-success">إضافة منطقة جديدة</a>
    </div>

    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif

    <table class="table table-bordered table-striped text-center">
        <thead class="table-light">
            <tr>
                <th>الرقن</th>
                <th>اسم المنطقة</th>
                <th>المدينة</th>
                <th>الإجراءات</th>
            </tr>
        </thead>
        <tbody>
            @forelse ($areas as $index => $area)
                <tr>
                    <td>{{ $index + 1 }}</td>
                    <td>{{ $area->name }}</td>
                    <td>{{ $area->city->name ?? 'غير محددة' }}</td>
                    <td>
                        <a href="{{ route('areas.edit', $area->id) }}" class="btn btn-sm btn-warning">تعديل</a>

                        <form action="{{ route('areas.destroy', $area->id) }}" method="POST" style="display:inline-block;">
                            @csrf
                            @method('DELETE')
                            <button class="btn btn-sm btn-danger" onclick="return confirm('هل أنت متأكد من الحذف؟')">حذف</button>
                        </form>
                    </td>
                </tr>
            @empty
                <tr>
                    <td colspan="4" class="text-muted">لا توجد مناطق حتى الآن</td>
                </tr>
            @endforelse
        </tbody>
    </table>
</div>

@endsection
