<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::disableForeignKeyConstraints();
        Schema::create('licenses', function (Blueprint $table) {
            $table->id();
            $table->foreignId('branche_id')->constrained('branches')->onDelete('cascade');
            $table->enum('status',['under_review','approved','rejected']);
            $table->foreignId('current_user_id')->constrained('users')->onDelete('cascade');
            $table->string('note');
             $table->foreignId('next_user_id')->constrained('users')->onDelete('cascade');
            $table->string('final_status');
            $table->timestamps();
        });

        
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('licenses');
    }
};
