<?php

namespace App\Models;


// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laratrust\Contracts\LaratrustUser;
use Laratrust\Traits\HasRolesAndPermissions;


use Laratrust\Traits\LaratrustUserTrait;


// implements LaratrustUser

class User extends Authenticatable
{
    /** @use HasFactory<\Database\Factories\UserFactory> */
    use HasFactory, Notifiable;
     use HasRolesAndPermissions;

    
     

    /**
     * The attributes that are mass assignable.
     *
     * @var list<string>
     */
    protected $fillable = [
        'name',
        'email',
        'password',
    ];
    public function index(){
        $usersCount = User::count();
        return view('admin.user.main_menus',compact('usersCount'));
    }

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var list<string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * Get the attributes that should be cast.
     *
     * @return array<string, string>
     */
    protected function casts(): array
    {
        return [
            'email_verified_at' => 'datetime',
            'password' => 'hashed',
        ];
    }
    public function city(){

   return 
   $this -> belongsTo(City::class);
    }

         public function roles()
{
    return $this->belongsToMany(\App\Models\Role::class);
}
    public function school()
{
    return $this->hasOne(School::class);
}


    public function schools()
    {
        return $this->hasMany(School::class);
    }



public function hasPermission($permission)
{
    $permissions = json_decode($this->permissions, true) ?? [];
    return in_array($permission, $permissions);
}

public function branches(){
    return $this->hasMany(\App\Models\Branch::class.'user_id');
}


}
