<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Renwel extends Model
{
    //
     protected $table ='Renewals';

    protected $fillable = [
    
    'school_id',
    
    'branch_name',
    'area_id',
    'sections',
    'user_id',

    'teachers_documents',
    'renewal_form',
    'certificate_purchase_receipt',
    'occupancy_receipt',
    'rental_contract_image',
    'director_image',
    'stage_addition_receipt',
    'community_contribution_receipt',
    'civil_defense_receipt',
    'book_purchase_receipt',
    'violations',
    'capacity',

    'students_count',
    'classes_count',
    'teachers_count',
    'pass_count',
    'fail_count',
    'curriculums_count',
    'class_hours',
    'workforce_count',

    'has_violations',
    'has_capacity_issue',
    'status',
        'notes',
        'admin_document'


        // ... بقية الحقول ...
    ];

    // علاقة مع المدرسة
public function school()
{
    return $this->belongsTo(School::class, 'school_id');
}

public function area()
{
    return $this->belongsTo(Area::class, 'area_id');
}

    // علاقة مع المستخدم من خلال المدرسة
    public function user()
    {
        return $this->belongsTo(User::class);
    }
       protected $casts = [
        'sections' => 'array',
    ];




}
