<?php

namespace App\Models;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class License extends Model
{
    //
      use HasFactory;

    protected $fillable = [
        'branche_id',
        'status',
        'current_user_id',
        'note',
        'next_user_id',
        'final_status',
    ];

  
    public function branch()
    {
        return $this->belongsTo(Branch::class, 'branche_id');
    }

    public function currentUser()
    {
        return $this->belongsTo(User::class, 'current_user_id');
    }

    public function nextUser()
    {
        return $this->belongsTo(User::class, 'next_user_id');
    }

        public function index(){
        $licensesCount = License::count();
        return view('admin.user.main_menus',compact('licensesCount'));
    }

public function school()
{
    return $this->belongsTo(\App\Models\School::class);
}

public function user()
{
    return $this->belongsTo(\App\Models\User::class);
}



  

}
