<?php

namespace App\Mail;

use App\Models\License;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;
use App\Mail\RenewalSubmission;

class LicenseStatusUpdated extends Mailable
{
     use Queueable, SerializesModels;

    public $license;



    public $schoolName;
    public $branchName;
    public $status;
    public $note;
    public $updatedAt;


    /**
     * Create a new message instance.
     */
    


    public function __construct(License $license)
    {
          $this->license = $license;
       
    }



    public function build()
    {
              return $this->subject('تم تحديث حالة ترخيص المدرسة')
            ->view('emails.license_status_updated');



    }
    

    /**
     * Get the message envelope.
     */
    public function envelope(): Envelope
    {
        return new Envelope(
            subject: 'License Status Updated',
        );
    }

    /**
     * Get the message content definition.
     */
    public function content(): Content
    {
        return new Content(
            view: 'emails.license_status_updated',
        );
    }

    /**
     * Get the attachments for the message.
     *
     * @return array<int, \Illuminate\Mail\Mailables\Attachment>
     */
    public function attachments(): array
    {
        return [];
    }
    
}
