<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth; // ✅ هذا السطر مهم

class RedirectIfNotClient
{
    public function handle(Request $request, Closure $next)
    {
        if (!Auth::check()) {
            return redirect()->route('login'); // أو أي Route لصفحة تسجيل الدخول
        }

        return $next($request);
    }
}
