<?php

namespace App\Http\Controllers;

use App\Models\City;
use App\Models\Role;
use App\Models\User;
use Illuminate\Http\Request;

class UserController extends Controller
{
    //
    public function index(Request $request)
    {
        $query = User::query();

        if ($request->has('email') && $request->email !== null) {
            $query->where('email', 'like', '%' . $request->email . '%');
        }

        $users = $query->latest()->get(); 

        return view('admin.user.all_user', compact('users'));
    }

    public function liveSearch(Request $request)
    {
        $search = $request->input('search');

        $users = User::where('name', 'like', "%$search%")
            ->orWhere('email', 'like', "%$search%")
            ->orWhere('phone', 'like', "%$search%")
            ->with(['roles', 'city'])
            ->limit(10)
            ->get();

        return view('admin.user.search_result', compact('users'))->render();
    }

    public function create()
    {
        $cities = City::all();
        return view('admin.user.add_user', compact('cities'));
    }

    public function store(Request $request)
    {
       dd("hhhhh");
        $request->validate([
            'name'     => 'required|string|max:255',
            'email'    => 'required|email|unique:users,email',
            'phone'    => 'nullable|string|max:20',
            'password' => 'required|string|min:6',
            'gender'   => 'required|in:male,femal',
            'city_id'  => 'required|exists:cities,id',
            'image'    => 'nullable|image|mimes:jpg,jpeg,png|max:2048',
        ]);

        $user = new User();
        $user->name = $request->name;
        $user->email = $request->email;
        $user->phone = $request->phone;
        $user->password = bcrypt($request->password);
        $user->gender = $request->gender;
        $user->city_id = $request->city_id;

        if ($request->hasFile('image')) {
            $path = $request->file('image')->store('uploads', 'public');
            $user->image = 'storage/' . $path;
        }

        $user->save();

        return redirect()->route('users.index')->with('success', 'تمت إضافة المستخدم بنجاح');
    }

    public function edit($id)
    {
        $user = User::findOrFail($id);
        $cities = City::all();
        return view('admin.user.edit_user', compact('user', 'cities'));
    }

    public function update(Request $request, $id)
    {
        $user = User::findOrFail($id);

        $request->validate([
            'name'     => 'required|string|max:255',
            'email'    => 'required|email|unique:users,email,' . $user->id,
            'phone'    => 'nullable|string|max:20',
            'password' => 'nullable|string|min:6',
            'gender'   => 'required|in:male,female',
            'city_id'  => 'required|exists:cities,id',
            'image'    => 'nullable|image|mimes:jpg,jpeg,png|max:2048',
        ]);

        $user->name = $request->name;
        $user->email = $request->email;
        $user->phone = $request->phone;

        if ($request->filled('password')) {
            $user->password = bcrypt($request->password);
        }

        $user->gender = $request->gender;
        $user->city_id = $request->city_id;

        if ($request->hasFile('image')) {
            $path = $request->file('image')->store('uploads', 'public');
            $user->image = 'storage/' . $path;
        }

        $user->save();

        return redirect()->route('users.index')->with('success', 'تم التعديل بنجاح');
  
    }

    public function destroy($id)
    {
        $user = User::findOrFail($id);
        $user->delete();
        return redirect()->route('users.index')->with('success', 'تم الحذف بنجاح');
    }

    public function showAssignRoleForm($id)
    {
        $user = User::findOrFail($id);
        $roles = Role::pluck('name', 'name');
        return view('admin.assign_role', compact('user', 'roles'));
    }

    public function assignRole(Request $request, $id)
    {
        $user = User::findOrFail($id);

        $request->validate([
            'role' => 'required|exists:roles,name',
        ]);

        $role = Role::where('name', $request->role)->first();

        if (!$role) {
            return redirect()->back()->withErrors(['role' => 'الدور غير موجود']);
        }

        $user->roles()->detach();
        $user->roles()->attach($role->id, ['user_type' => 'App\Models\User']);

        return redirect()->route('users.roles')->with('success', 'تم تعيين الدور بنجاح');
    }

    public function usersWithRoles(Request $request)
    {
        $query = User::with('roles');

        if ($request->has('email') && $request->email !== null) {
            $query->where('email', 'like', '%' . $request->email . '%');
        }

        $users = $query->paginate(10);
        return view('admin.role.index', compact('users'));
    }
}













