<?php

namespace App\Http\Controllers;

use App\Mail\RenewalStatusUpdated;
use Illuminate\Http\Request;
use App\Models\Renewal;
use App\Models\Branch;
use App\Models\Renwel;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Storage;

use function Illuminate\Log\log;

class RenewalTrackingControllerController extends Controller
{
    //


        public function index()
    {
        // جلب بيانات تجديدات الترخيص الخاصة بالمستخدم الحالي فقط
        $userId = Auth::id();

        $renewals = Renwel::with(['school', 'area'])
            ->where('user_id', $userId)
            ->get();

        return view('client.result', compact('renewals'));
    }




public function update(Request $request, $id)
{
    $request->validate([
        'status' => 'required|string',
        'notes' => 'nullable|string',
        'admin_document' => 'nullable|file|mimes:pdf,jpg,jpeg,png|max:5120',
    ]);

    // جلب طلب التجديد
    $renewal = Renwel::with('user', 'school')->findOrFail($id);

    // رفع ملف الموافقة إذا وُجد
    if ($request->hasFile('admin_document')) {
        if ($renewal->admin_document) {
            Storage::disk('public')->delete($renewal->admin_document);
        }
        $renewal->admin_document = $request->file('admin_document')->store('admin_docs', 'public');
    }

    // تحديث الحالة والملاحظات
    $renewal->status = $request->status;      // يجب أن يكون 'مقبول' أو 'مرفوض' أو 'قيد المراجعة'
    $renewal->notes = $request->notes;        // الاسم الصحيح هو notes
    $renewal->save();

    // إعادة تحميل البيانات للتأكد من التحديث
    $renewal->refresh();

    // إرسال البريد الإلكتروني
    if ($renewal->user && $renewal->user->email) {
        Mail::to($renewal->user->email)->send(new RenewalStatusUpdated($renewal));
    }

    return redirect()->back()->with('success', 'تم حفظ التعديلات وإرسال الإيميل بنجاح.');
}

}