<?php

namespace App\Http\Controllers;
use App\Http\Controllers\Controller;
use App\Models\Area;
use App\Models\Branch;
use App\Models\City;
use App\Models\Renewal;
use App\Models\Renewel;
use App\Models\Renwel;
use App\Models\School;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\DB;



use PhpOffice\PhpWord\PhpWord;
use PhpOffice\PhpWord\IOFactory;

use function Illuminate\Log\log;

class RenewLicenseController extends Controller
{
    //
  
     
    // عرض نموذج تجديد الترخيص
    public function create()
    {
        try {
            $user = Auth::user();
            $schools = $user->schools;
            $areas = Area::all();

            // if ($schools->isEmpty()) {
            //     return redirect()->route('client.renewal.noschool');
            // }

            return view('client.renew.create', compact('schools', 'areas'));
        } catch (\Exception $e) {
            Log::error('Error in RenewLicenseController@create: '.$e->getMessage());
            return back()->with('error', 'حدث خطأ تقني، يرجى المحاولة لاحقاً');
        }
    }

    
    // معالجة وحفظ الطلب
    public function store(Request $request)
{
    // قواعد التحقق
    $rules = [
        'school_id' => 'required|exists:schools,id',
        'branch_name' => 'required|string|max:255',
        'area_id' => 'required|exists:areas,id',
        'sections' => 'required|array|min:1',
        'sections.*' => 'in:عربي,إنجليزي',

        // مستندات أساسية
        'teachers_documents' => 'required|file|mimes:pdf,jpg,jpeg,png|max:5120',
        'renewal_form' => 'required|file|mimes:pdf,jpg,jpeg,png|max:5120',
        'director_image' => 'required|image|mimes:jpeg,png,jpg|max:2048',

        // مالية
        'certificate_purchase_receipt' => 'required|file|mimes:pdf,jpg,jpeg,png|max:5120',
        'occupancy_receipt' => 'required|file|mimes:pdf,jpg,jpeg,png|max:5120',
        'stage_addition_receipt' => 'required|file|mimes:pdf,jpg,jpeg,png|max:5120',
        'community_contribution_receipt' => 'required|file|mimes:pdf,jpg,jpeg,png|max:5120',
        'book_purchase_receipt' => 'required|file|mimes:pdf,jpg,jpeg,png|max:5120',

        // إضافية
        'rental_contract_image' => 'required|file|mimes:pdf,jpg,jpeg,png|max:5120',
        'civil_defense_receipt' => 'required|file|mimes:pdf,jpg,jpeg,png|max:5120',
        'violations' => 'nullable|file|mimes:pdf,jpg,jpeg,png|max:5120',
        'capacity' => 'nullable|file|mimes:pdf,jpg,jpeg,png|max:5120',

        // إحصائيات
        'students_count' => 'required|file',
        'classes_count' => 'required|file',
        'teachers_count' => 'required|file',
        'pass_count' => 'required|file',
        'fail_count' => 'required|file',
        'curriculums_count' => 'required|file',
        'class_hours' => 'required|file',
        'workforce_count' => 'required|file',

        // الموافقة
        'agreement' => 'required|accepted',
    ];

    // تحقق
    $validated = $request->validate($rules);

    DB::beginTransaction();

    try {
        // تجهيز مصفوفة البيانات الأساسية
        $data = [
            'school_id' => $validated['school_id'],
            'branch_name' => $validated['branch_name'],
            'area_id' => $validated['area_id'],
            'sections' => json_encode($validated['sections']),
            'user_id' => Auth::id(),
        ];

        // رفع الملفات — استخدم الدالة الموجودة لديك storeFile
        $fileFields = [
            'teachers_documents',
            'renewal_form',
            'director_image',
            'certificate_purchase_receipt',
            'occupancy_receipt',
            'stage_addition_receipt',
            'community_contribution_receipt',
            'book_purchase_receipt',
            'rental_contract_image',
            'civil_defense_receipt',
            'students_count',
            'classes_count',
            'teachers_count',
            'pass_count',
            'fail_count',
            'curriculums_count',
            'class_hours',
            'workforce_count',
        ];

        foreach ($fileFields as $field) {
            if ($request->hasFile($field)) {
                $data[$field] = $this->storeFile($request->file($field), 'renewals');
            } else {
                // لبعض الحقول المطلوبة، من المفترض أنها موجودة بسبب validate
                $data[$field] = $data[$field] ?? null;
            }
        }

        // ملفات اختيارية
        $data['violations'] = $request->hasFile('violations') ? $this->storeFile($request->file('violations'), 'renewals') : null;
        $data['capacity'] = $request->hasFile('capacity') ? $this->storeFile($request->file('capacity'), 'renewals') : null;

        // flags
        $data['has_violations'] = $request->has('has_violations') ? 1 : 0;
        $data['has_capacity_issue'] = $request->has('has_capacity_issue') ? 1 : 0;

        // تسجيل في اللوج للتأكد (يمكن إزالته لاحقًا)
        Log::info('Creating Renwel with data (keys): ' . implode(', ', array_keys($data)));
        Log::debug('Renwel create payload', $data);

        // إنشاء السجل باستخدام Mass Assignment (يعمل إذا $fillable صحيح)
        $renwel = \App\Models\Renwel::create($data);

        DB::commit();

        return redirect()->route('renew.success')->with('success', 'تم تقديم طلب تجديد الترخيص بنجاح!');
    } catch (\Exception $e) {
        DB::rollBack();

        Log::error('Error saving renewal: ' . $e->getMessage());
        Log::error('Request data: ', $request->all());
        Log::error('User ID: ' . Auth::id());
        Log::error('School ID: ' . $request->school_id);

        return back()->with('error', 'حدث خطأ أثناء الحفظ: ' . $e->getMessage())->withInput();
    }
}


    // رفع الملفات
    private function storeFile($file, $directory)
    {
        if ($file) {
            return $file->store($directory, 'public');
        }
        return null;
    }

    // صفحة النجاح
    public function success()
    {
        return view('client.renew.success');
    }





    public function add()
    {
        $cities = City::all();
        return view('client.renew.noschool', compact('cities'));
    }

    public function all(Request $request)
    {
       $request->validate([
            'school_name' => 'required|string|max:255',
            'city_id' => 'required|exists:cities,id',
            'type' => 'required|array',
            'logo' => 'nullable|image|max:2048',
        ]);


        $school = new School();
        $school->school_name = $request->school_name;
        $school->city_id = $request->city_id;
        $school->type = json_encode($request->type);
        $school->user_id = Auth::id(); // تعيين المستخدم الحالي
        if ($request->hasFile('logo')) {
            $school->logo = $request->file('logo')->store('school_logos', 'public');
        }
        $school->save();

        
         return redirect()->route('renew.create')->with('success','تم إرسال بيانات المدرسة بنجاح');
       
    }








}


