<?php

namespace App\Http\Controllers;

use App\Models\Branch;
use App\Models\License;
use App\Models\User;
use Illuminate\Http\Request;

class LicenseController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {

        //اللي اضفته
         $users = User::whereHas('roles', function ($query) {
         $query->where('name', 'committee_member');
          })->get();

        
        $licenses = License::with('branch', 'currentUser', 'nextUser')->get();
        return view('admin.licenses.all_license', compact('licenses','users'));

    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
        $licenses = License::all();
        $branches = Branch::all();
        $users = User::whereHas('roles', function ($query) {
        $query->where('name', 'committee_member');
         })->get();

        return view('admin.licenses.add_license', compact('branches', 'users'));

    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
                $request->validate([
            'branche_id' => 'required|exists:branches,id',
            'status' => 'required|in:under_review,approved,rejected',
            'current_user_id' => 'required|exists:users,id',
            'note' => 'required|string',
            'next_user_id' => 'required|exists:users,id',
            'final_status' => 'required|string',
        ]);

        License::create($request->all());

        return redirect()->route('licenses.index')->with('success', 'تم إضافة الترخيص بنجاح');

    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
        $license = License::findOrFail($id);
        $branches = Branch::all();
        $users = User::whereHas('roles', function ($query) {
         $query->where('name', 'committee_member');
         })->get();

        return view('admin.licenses.edit_license', compact('license', 'branches', 'users'));

    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
                $license = License::findOrFail($id);

        $request->validate([
            'branche_id' => 'required|exists:branches,id',
            'status' => 'required|in:under_review,approved,rejected',
            'current_user_id' => 'required|exists:users,id',
            'note' => 'required|string',
            'next_user_id' => 'required|exists:users,id',
            'final_status' => 'required|string',
        ]);

        $license->update($request->all());

        return redirect()->route('licenses.index')->with('success', 'تم تعديل الترخيص بنجاح');

    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
                $license = License::findOrFail($id);
        $license->delete();

        return redirect()->route('licenses.index')->with('success', 'تم حذف الترخيص بنجاح');
    }




    
}
