<?php

namespace App\Http\Controllers;

use App\Models\Branch;
use App\Models\License;
use App\Models\School;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class ClientLicenseController extends Controller
{
    //



    public function trackResult()
    {
     
        $user = Auth::user();
        $branches=Branch::with(['school','licenses'])

            ->whereHas('school', function ($query) use ($user) {
                $query->where('user_id', $user->id);
       })
            ->get();

        return view('client.track_result', compact('branches'));
    }

public function licenseStatus()
{
    $user = Auth::user();

    // جلب جميع الفروع المرتبطة بمدرسة المستخدم
    $branches = Branch::whereHas('school', function ($query) use ($user) {
        $query->where('user_id', $user->id);
    })->with(['licenses' => function ($query) {
        $query->latest()->limit(1); // آخر ترخيص لكل فرع
    }, 'school'])->get();

    return view('client.branches_status', compact('branches'));
}



}





