<?php

namespace App\Http\Controllers;

use App\Models\City;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;

class AuthRegisterController extends Controller
{

    public function showRegistrationForm()
    {
        $cities = City::all();
        return view('client.register', compact('cities'));
    }

    public function register(Request $request)
    {


         dd("k");

        return response()->json($request->all());
        // رسائل التحقق المخصصة بالعربية
        $messages = [
            'name.required' => 'حقل الاسم الكامل مطلوب',
            'email.required' => 'حقل البريد الإلكتروني مطلوب',
            'email.email' => 'يجب أن يكون البريد الإلكتروني صالحاً',
            'email.unique' => 'هذا البريد الإلكتروني مستخدم من قبل، يرجى استخدام بريد آخر',
            'phone.required' => 'حقل رقم الهاتف مطلوب',
            'gender.required' => 'حقل الجنس مطلوب',
            'gender.in' => 'القيمة المحددة للجنس غير صالحة. يرجى اختيار ذكر أو أنثى.', // رسالة أوضح
            'city_id.required' => 'حقل المحافظة مطلوب',
            'city_id.exists' => 'المحافظة المحددة غير موجودة',
            'password.required' => 'حقل كلمة المرور مطلوب',
            'password.min' => 'يجب أن تتكون كلمة المرور من 6 أحرف على الأقل',
            'password.confirmed' => 'كلمة المرور وتأكيدها غير متطابقين',
            'image.image' => 'يجب أن يكون الملف صورة',
            'image.max' => 'يجب ألا يتجاوز حجم الصورة 2 ميجابايت',
        ];

        $request->validate([
            'name'     => 'required|string|max:255',
            'email'    => 'required|email|unique:users',
            'phone'    => 'required|string',
            'image'    => 'nullable|image|max:2048',
            'gender'   => 'required|in:male,femal',
            'city_id'  => 'required|exists:cities,id',
            'password' => 'required|string|min:6|confirmed',
        ], $messages);

        // معالجة رفع الصورة
        $imageName = null;
        if ($request->hasFile('image')) {
            $imageName = time().'_'.$request->image->getClientOriginalName();
            $request->image->move(public_path('uploads'), $imageName);
        }

        // إنشاء المستخدم
        User::create([
            'name'     => $request->name,
            'email'    => $request->email,
            'phone'    => $request->phone,
            'image'    => $imageName,
            'gender'   => $request->gender,
            'city_id'  => $request->city_id,
            'password' => Hash::make($request->password),
        ]);

        return redirect()->route('login')->with('success', 'تم التسجيل بنجاح');
    
    }

    public function dashboard()
    {
        return view('client.dashboard');
    }
}
