<?php

namespace App\Http\Controllers;

use App\Models\Area;
use App\Models\City;
use Illuminate\Http\Request;

class AreaController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //
         $areas = Area::with('city')->get();
        return view('admin.areas.all_area', compact('areas'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
        $areas = Area::all();
        $cities = City::all();
        return view('admin.areas.add_area', compact('areas','cities'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
            
        $area = new Area();
        $area->name = $request->name;
        $area->city_id = $request->city_id;
        $area->save();
        return redirect()->route('areas.index')->with('success', 'تمت إضافة المدرسة بنجاح');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
         $area = Area::findOrFail($id);
        $cities = City::all();
        return view('admin.areas.edit_area', compact('area', 'cities'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, $id)
    {
        //
        
        $area = Area::findOrFail($id);
        $area->name = $request->name;
        $area->city_id = $request->city_id;
        $area->save();
        return redirect()->route('areas.index')->with('success', 'تم تعديل المدرسة بنجاح');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
        $area = Area::findOrFail($id);
        $area->delete();

        return redirect()->route('areas.index')->with('success', 'تم حذف المدرسة بنجاح');
    }
}
