<?php

namespace App\Http\Controllers;

use App\Models\Branch;
use App\Models\License;
use App\Models\User;
use Illuminate\Http\Request;

class AdminLicenseController extends Controller
{
    //

    //
        // عرض تفاصيل ترخيص محدد
         // عرض جميع التراخيص للجنة
       // عرض كل التراخيص
     // عرض كل التراخيص
       
    public function index($status = null)
    {
        $licenses = License::with(['school','branch', 'currentUser', 'nextUser'])->get();
        $query = License::with('branch');

        if ($status) {
            $query->where('status', $status);
        }

        $licenses = $query->get();

        return view('admin.licenses.index', [
            'licenses' => $licenses,
            'status' => $status
        ]);
    }

    public function create()
    {
        $branches = Branch::all();
        $users = User::whereHas('roles', function ($query) {
            $query->where('name', 'admin_member');
        })->get();

        return view('admin.licenses.create', compact('branches', 'users'));
    }

    public function show($id)
    {
        $license = License::with([
            'branch.school.city',
            'branch.area.city',
            'currentUser',
            'nextUser'
        ])->findOrFail($id);

        $branch = $license->branch;

        // إعداد قائمة الملفات مع المسار الصحيح
        $files = [
            'السيرة الذاتية لمدير المدرسة' => $branch->cv_manage,
            'عقد الإيجار' => $branch->contrect_image,
            'مخطط مبنى المدرسة (اختياري)' => $branch->plan_image,
            'الصورة الرئيسية' => $branch->main_image,
            'الصور الفرعية' => $branch->secondary_image,
            'دراسة الجدوى' => $branch->file_feasibility,
            'كشف الحساب البنكي' => $branch->bank_statement,
            'وثائق أخرى' => $branch->other_document,
        ];

        return view('admin.licenses.show', compact('license', 'files'));
    }

    public function add($id)
    {
        $license = License::with([
            'branch.school.city',
            'branch.area.city',
            'currentUser',
            'nextUser'
        ])->findOrFail($id);

        // جلب كل المستخدمين للجنة لاختيار المستخدم الحالي والتالي
        $users = User::whereHas('roles', function ($query) {
            $query->where('name', 'committee_member');
        })->get();

        return view('admin.licenses.add', compact('license', 'users'));
    }

    public function updateStatus(Request $request, $id)
{
    $request->validate([
        'status' => 'nullable|string',
        'final_status' => 'nullable|string',
        'note' => 'nullable|string',
        'current_user_id' => 'nullable|exists:users,id',
        'next_user_id' => 'nullable|exists:users,id',
        'approval_file' => 'nullable|file|mimes:pdf|max:2048', // ✅ إضافة التحقق من الملف
    ]);

    $license = License::findOrFail($id);

    $license->status = $request->status;
    $license->final_status = $request->final_status;
    $license->note = $request->note;
    $license->current_user_id = $request->current_user_id;
    $license->next_user_id = $request->next_user_id;

    // ✅ رفع ملف الموافقة
    if ($request->hasFile('approval_file')) {
        $file = $request->file('approval_file');
        $filename = time() . '_' . $file->getClientOriginalName();
        $path = $file->storeAs('approval_files', $filename, 'public');
        $license->approval_file = $path;
    }

    $license->save();

    return redirect()->back()->with('success', 'تم تحديث بيانات الترخيص بنجاح.');
}




    public function store(Request $request)
    {
        $request->validate([
            'branch_id' => 'required|exists:branches,id',
            'school_id' => 'required|exists:schools,id',
            'status' => 'required|string',
            'current_user_id' => 'nullable|exists:users,id',
            'next_user_id' => 'nullable|exists:users,id',
            'note' => 'nullable|string',
            'final_status' => 'nullable|string',
        ]);

        License::create($request->all());
        return redirect()->route('licenses.index')->with('success', 'تم إنشاء الترخيص بنجاح');
    }

    public function edit($id)
    {
        $license = License::findOrFail($id);
        $users = User::whereHas('roles', function ($query) {
            $query->where('name', 'committee_member');
        })->get();

        return view('admin.licenses.edit', compact('license','users'));
    }



   public function update(Request $request, $id)
{
    $license = License::findOrFail($id);

    $request->validate([
        'status' => 'required|in:under_review,approved,rejected',
        'note' => 'nullable|string',
        'final_status' => 'nullable|string',
        'approval_file' => 'nullable|file|mimes:pdf|max:2048',
    ]);

    $license->status = $request->status;
    $license->note = $request->note;
    $license->final_status = $request->final_status;

    // ✅ رفع ملف الموافقة
    
 

    // رفع ملف الموافقة إن وُجد
    if ($request->hasFile('approval_file')) {
        $file = $request->file('approval_file');
        $filename = time() . '_' . $file->getClientOriginalName();
        $path = $file->storeAs('licenses/approval_files', $filename, 'public');
        $license->approval_file = $path;
    }

    // حفظ باقي الحقول إن وجدت (اختر ما يناسبك)
    // مثال:
    // $license->status = $request->input('status');

    $license->save();

    return redirect()->back()->with('success', 'تم حفظ ملف الموافقة بنجاح');
}

    public function destroy($id)
    {
        $license = License::findOrFail($id);
        $license->delete();
        return redirect()->route('admin.licenses.index')->with('success', 'تم حذف الترخيص بنجاح');
    }

    public function statusFilter($status)
    {
        $licenses = License::where('status', $status)->get();

        return view('admin.licenses.filtered', compact('licenses', 'status'));
    }

    


}


